/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicDateHourVector;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicDateTimeVector;
import com.xxdb.data.BasicDateVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicMonthVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicNanoTimestampVector;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.BasicTimestampVector;
import com.xxdb.data.Entity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String JAVA_API_VERSION = "3.00.2.0";
    public static final int DISPLAY_ROWS = 20;
    public static final int DISPLAY_COLS = 100;
    public static final int DISPLAY_WIDTH = 100;
    private static final int[] cumMonthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] cumLeapMonthDays = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] leapMonthDays = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static int SCALE = -1;
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final long MILLS_PER_DAY = 86400000L;
    private static final BigDecimal DECIMAL128_MIN_VALUE = new BigDecimal("-170141183460469231731687303715884105728");
    private static final BigDecimal DECIMAL128_MAX_VALUE = new BigDecimal("170141183460469231731687303715884105728");

    public static String getJavaApiVersion() {
        return JAVA_API_VERSION;
    }

    public static void setFormat(int scale) {
        SCALE = scale;
    }

    public static int countMonths(YearMonth date) {
        return date.getYear() * 12 + date.getMonthValue() - 1;
    }

    public static int countMonths(int year, int month) {
        return year * 12 + month - 1;
    }

    public static int countMonths(int days) {
        int month;
        boolean leap;
        int circleIn400Years = (days += 719529) / 146097;
        int offsetIn400Years = days % 146097;
        int resultYear = circleIn400Years * 400;
        int similarYears = offsetIn400Years / 365;
        int tmpDays = similarYears * 365;
        if (similarYears > 0) {
            tmpDays += (similarYears - 1) / 4 + 1 - (similarYears - 1) / 100;
        }
        if (tmpDays >= offsetIn400Years) {
            --similarYears;
        }
        int year = similarYears + resultYear;
        boolean bl = leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        if ((days -= circleIn400Years * 146097 + tmpDays) <= 0) {
            days += leap ? 366 : 365;
        }
        if (leap) {
            month = days / 32 + 1;
            if (days > cumLeapMonthDays[month]) {
                ++month;
            }
        } else {
            month = days / 32 + 1;
            if (days > cumMonthDays[month]) {
                ++month;
            }
        }
        return year * 12 + month - 1;
    }

    public static YearMonth parseMonth(int value) {
        return YearMonth.of(value / 12, value % 12 + 1);
    }

    public static int countDays(LocalDate date) {
        return Utils.countDays(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static int countDays(Calendar calendar) {
        return Utils.countDays(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static int countDays(int year, int month, int day) {
        if (month < 1 || month > 12 || day < 0) {
            return Integer.MIN_VALUE;
        }
        int divide400Years = year / 400;
        int offset400Years = year % 400;
        int days = divide400Years * 146097 + offset400Years * 365 - 719529;
        if (offset400Years > 0) {
            days += (offset400Years - 1) / 4 + 1 - (offset400Years - 1) / 100;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return day <= leapMonthDays[month - 1] ? (days += cumLeapMonthDays[month - 1]) + day : Integer.MIN_VALUE;
        }
        return day <= monthDays[month - 1] ? (days += cumMonthDays[month - 1]) + day : Integer.MIN_VALUE;
    }

    public static LocalDate parseDate(int days) {
        int day;
        int month;
        boolean leap;
        int circleIn400Years = (days += 719529) / 146097;
        int offsetIn400Years = days % 146097;
        int resultYear = circleIn400Years * 400;
        int similarYears = offsetIn400Years / 365;
        int tmpDays = similarYears * 365;
        if (similarYears > 0) {
            tmpDays += (similarYears - 1) / 4 + 1 - (similarYears - 1) / 100;
        }
        if (tmpDays >= offsetIn400Years) {
            --similarYears;
        }
        int year = similarYears + resultYear;
        boolean bl = leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        if ((days -= circleIn400Years * 146097 + tmpDays) <= 0) {
            days += leap ? 366 : 365;
        }
        if (leap) {
            month = days / 32 + 1;
            if (days > cumLeapMonthDays[month]) {
                ++month;
            }
            day = days - cumLeapMonthDays[month - 1];
        } else {
            month = days / 32 + 1;
            if (days > cumMonthDays[month]) {
                ++month;
            }
            day = days - cumMonthDays[month - 1];
        }
        return LocalDate.of(year, month, day);
    }

    public static int countSeconds(LocalDateTime dt) {
        return Utils.countDTSeconds(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond());
    }

    private static long countSecondsToLong(LocalDateTime dt) {
        return Utils.countDTSecondsToLong(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond());
    }

    public static int countSeconds(Calendar value) {
        return Utils.countSeconds(value.get(11), value.get(12), value.get(13));
    }

    public static int countDTSeconds(Calendar value) {
        return Utils.countDTSeconds(value.get(1), value.get(2) + 1, value.get(5), value.get(11), value.get(12), value.get(13));
    }

    public static int countDTSeconds(int year, int month, int day, int hour, int minute, int second) {
        int days = Utils.countDays(year, month, day);
        return days * 86400 + (hour * 60 + minute) * 60 + second;
    }

    private static long countDTSecondsToLong(int year, int month, int day, int hour, int minute, int second) {
        long days = Utils.countDays(year, month, day);
        return days * 86400L + (long)((hour * 60 + minute) * 60) + (long)second;
    }

    public static int divide(int x, int y) {
        int tmp = x / y;
        if (x >= 0) {
            return tmp;
        }
        if (x % y < 0) {
            return tmp - 1;
        }
        return tmp;
    }

    public static long divide(long x, long y) {
        long tmp = x / y;
        if (x >= 0L) {
            return tmp;
        }
        if (x % y < 0L) {
            return tmp - 1L;
        }
        return tmp;
    }

    public static LocalDateTime parseDateTime(int seconds) {
        LocalDate date = Utils.parseDate(Utils.divide(seconds, 86400));
        if ((seconds %= 86400) < 0) {
            seconds += 86400;
        }
        int hour = seconds / 3600;
        int minute = (seconds %= 3600) / 60;
        int second = seconds % 60;
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), hour, minute, second);
    }

    public static int countHours(LocalDateTime dt) {
        return Utils.countHours(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour());
    }

    public static int countHours(Calendar calendar) {
        return Utils.countHours(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11));
    }

    public static int countHours(int year, int month, int day, int hour) {
        int days = Utils.countDays(year, month, day);
        return days * 24 + hour;
    }

    public static LocalDateTime parseDateHour(int hours) {
        LocalDate date = Utils.parseDate(Utils.divide(hours, 24));
        if ((hours %= 24) < 0) {
            hours += 24;
        }
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), hours, 0);
    }

    public static long countMilliseconds(LocalDateTime dt) {
        long seconds = Utils.countSecondsToLong(dt);
        return seconds * 1000L + (long)(dt.getNano() / 1000000);
    }

    public static long countMilliseconds(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return (long)Utils.countDTSeconds(year, month, day, hour, minute, second) * 1000L + (long)millisecond;
    }

    public static long countDTNanoseconds(LocalDateTime dt) {
        long seconds = Utils.countSecondsToLong(dt);
        return seconds * 1000000000L + (long)dt.getNano();
    }

    public static LocalDateTime parseTimestamp(long milliseconds) {
        int days = (int)Math.floor((double)milliseconds / 8.64E7);
        LocalDate date = Utils.parseDate(days);
        if ((milliseconds %= 86400000L) < 0L) {
            milliseconds += 86400000L;
        }
        int millisecond = (int)(milliseconds % 1000L);
        int seconds = (int)(milliseconds / 1000L);
        int hour = seconds / 3600;
        int minute = (seconds %= 3600) / 60;
        int second = seconds % 60;
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), hour, minute, second, millisecond * 1000000);
    }

    public static LocalDateTime parseNanoTimestamp(long nanoseconds) {
        int days = (int)(nanoseconds / 86400000000000L);
        if (nanoseconds < 0L && nanoseconds % 86400000000000L != 0L) {
            --days;
        }
        LocalDate date = Utils.parseDate(days);
        if ((nanoseconds %= 86400000000000L) < 0L) {
            nanoseconds += 86400000000000L;
        }
        LocalTime time = Utils.parseNanoTime(nanoseconds % 86400000000000L);
        return LocalDateTime.of(date, time);
    }

    public static int countMilliseconds(LocalTime time) {
        return Utils.countMilliseconds(time.getHour(), time.getMinute(), time.getSecond(), time.getNano() / 1000000);
    }

    public static int countMilliseconds(Calendar value) {
        return Utils.countMilliseconds(value.get(11), value.get(12), value.get(13), value.get(14));
    }

    public static long countDateMilliseconds(Calendar value) {
        return Utils.countMilliseconds(value.get(1), value.get(2) + 1, value.get(5), value.get(11), value.get(12), value.get(13), value.get(14));
    }

    public static int countMilliseconds(int hour, int minute, int second, int millisecond) {
        return ((hour * 60 + minute) * 60 + second) * 1000 + millisecond;
    }

    public static long countNanoseconds(LocalTime time) {
        return (long)Utils.countMilliseconds(time.getHour(), time.getMinute(), time.getSecond(), 0) * 1000000L + (long)time.getNano();
    }

    public static long countNanoseconds(LocalDateTime time) {
        return Utils.countMilliseconds(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond(), 0) * 1000000L + (long)time.getNano();
    }

    public static LocalTime parseTime(int milliseconds) {
        return LocalTime.of(milliseconds / 3600000, milliseconds / 60000 % 60, milliseconds / 1000 % 60, milliseconds % 1000 * 1000000);
    }

    public static LocalTime parseNanoTime(long nanoOfDay) {
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    public static int countSeconds(LocalTime time) {
        return Utils.countSeconds(time.getHour(), time.getMinute(), time.getSecond());
    }

    public static int countSeconds(int hour, int minute, int second) {
        return (hour * 60 + minute) * 60 + second;
    }

    public static LocalTime parseSecond(int seconds) {
        return LocalTime.of(seconds / 3600, seconds % 3600 / 60, seconds % 60);
    }

    public static int countMinutes(LocalTime time) {
        return Utils.countMinutes(time.getHour(), time.getMinute());
    }

    public static int countMinutes(Calendar value) {
        return Utils.countMinutes(value.get(11), value.get(12));
    }

    public static int countMinutes(int hour, int minute) {
        return hour * 60 + minute;
    }

    public static LocalTime parseMinute(int minutes) {
        int hours = minutes / 60;
        int remainingMinutes = minutes % 60;
        if (minutes < 0) {
            hours = (hours - 1 + 24) % 24;
            remainingMinutes = 60 - Math.abs(remainingMinutes);
        }
        return LocalTime.of(hours, remainingMinutes);
    }

    public static int murmur32(byte[] data, int len, int seed) {
        int h = len;
        int length4 = len / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data[i4 + 0] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (len % 4) {
            case 3: {
                h ^= (data[(len & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(len & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[len & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static Entity.DATA_CATEGORY getCategory(Entity.DATA_TYPE type) {
        if (type == Entity.DATA_TYPE.DT_TIME || type == Entity.DATA_TYPE.DT_SECOND || type == Entity.DATA_TYPE.DT_MINUTE || type == Entity.DATA_TYPE.DT_DATE || type == Entity.DATA_TYPE.DT_DATEHOUR || type == Entity.DATA_TYPE.DT_DATEMINUTE || type == Entity.DATA_TYPE.DT_DATETIME || type == Entity.DATA_TYPE.DT_MONTH || type == Entity.DATA_TYPE.DT_NANOTIME || type == Entity.DATA_TYPE.DT_NANOTIMESTAMP || type == Entity.DATA_TYPE.DT_TIMESTAMP) {
            return Entity.DATA_CATEGORY.TEMPORAL;
        }
        if (type == Entity.DATA_TYPE.DT_INT || type == Entity.DATA_TYPE.DT_LONG || type == Entity.DATA_TYPE.DT_SHORT || type == Entity.DATA_TYPE.DT_BYTE) {
            return Entity.DATA_CATEGORY.INTEGRAL;
        }
        if (type == Entity.DATA_TYPE.DT_BOOL) {
            return Entity.DATA_CATEGORY.LOGICAL;
        }
        if (type == Entity.DATA_TYPE.DT_DOUBLE || type == Entity.DATA_TYPE.DT_FLOAT) {
            return Entity.DATA_CATEGORY.FLOATING;
        }
        if (type == Entity.DATA_TYPE.DT_STRING || type == Entity.DATA_TYPE.DT_SYMBOL || type == Entity.DATA_TYPE.DT_BLOB) {
            return Entity.DATA_CATEGORY.LITERAL;
        }
        if (type == Entity.DATA_TYPE.DT_INT128 || type == Entity.DATA_TYPE.DT_UUID || type == Entity.DATA_TYPE.DT_IPADDR) {
            return Entity.DATA_CATEGORY.BINARY;
        }
        if (type == Entity.DATA_TYPE.DT_ANY || type == Entity.DATA_TYPE.DT_IOTANY) {
            return Entity.DATA_CATEGORY.MIXED;
        }
        if (type == Entity.DATA_TYPE.DT_VOID) {
            return Entity.DATA_CATEGORY.NOTHING;
        }
        if (type == Entity.DATA_TYPE.DT_DECIMAL32 || type == Entity.DATA_TYPE.DT_DECIMAL64 || type == Entity.DATA_TYPE.DT_DECIMAL128) {
            return Entity.DATA_CATEGORY.DENARY;
        }
        return Entity.DATA_CATEGORY.SYSTEM;
    }

    public static Entity toMonth(Entity source) {
        long scaleFactor = 1L;
        if (source.isScalar()) {
            switch (source.getDataType()) {
                case DT_NANOTIMESTAMP: {
                    scaleFactor = 86400000000000L;
                    int days = (int)Utils.divide(((BasicNanoTimestamp)source).getLong(), scaleFactor);
                    return new BasicMonth(Utils.countMonths(days));
                }
                case DT_TIMESTAMP: {
                    scaleFactor = 86400000L;
                    int days = (int)Utils.divide(((BasicTimestamp)source).getLong(), scaleFactor);
                    return new BasicMonth(Utils.countMonths(days));
                }
                case DT_DATETIME: {
                    scaleFactor = 86400L;
                    int days = Utils.divide(((BasicDateTime)source).getInt(), (int)scaleFactor);
                    return new BasicMonth(Utils.countMonths(days));
                }
                case DT_DATE: {
                    return new BasicMonth(Utils.countMonths(((BasicDate)source).getInt()));
                }
            }
            throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, DATETIME, or DATE.");
        }
        int rows = source.rows();
        int[] values = new int[rows];
        switch (source.getDataType()) {
            case DT_NANOTIMESTAMP: {
                scaleFactor = 86400000000000L;
                BasicNanoTimestampVector ntsVec = (BasicNanoTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.countMonths((int)Utils.divide(ntsVec.getLong(i), scaleFactor));
                }
                return new BasicMonthVector(values);
            }
            case DT_TIMESTAMP: {
                scaleFactor = 86400000L;
                BasicTimestampVector tsVec = (BasicTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.countMonths((int)Utils.divide(tsVec.getLong(i), scaleFactor));
                }
                return new BasicMonthVector(values);
            }
            case DT_DATETIME: {
                scaleFactor = 86400L;
                BasicDateTimeVector dtVec = (BasicDateTimeVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.countMonths(Utils.divide(dtVec.getInt(i), (int)scaleFactor));
                }
                return new BasicMonthVector(values);
            }
            case DT_DATE: {
                BasicDateVector dVec = (BasicDateVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.countMonths(dVec.getInt(i));
                }
                return new BasicMonthVector(values);
            }
        }
        throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, DATETIME, or DATE.");
    }

    public static Entity toDate(Entity source) {
        if (source.isScalar()) {
            long scaleFactor = 1L;
            switch (source.getDataType()) {
                case DT_NANOTIMESTAMP: {
                    scaleFactor = 86400000000000L;
                    return new BasicDate((int)Utils.divide(((BasicNanoTimestamp)source).getLong(), scaleFactor));
                }
                case DT_TIMESTAMP: {
                    scaleFactor = 86400000L;
                    return new BasicDate((int)Utils.divide(((BasicTimestamp)source).getLong(), scaleFactor));
                }
                case DT_DATETIME: {
                    scaleFactor = 86400L;
                    return new BasicDate(Utils.divide(((BasicDateTime)source).getInt(), (int)scaleFactor));
                }
            }
            throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, or DATETIME.");
        }
        long scaleFactor = 1L;
        int rows = source.rows();
        int[] values = new int[rows];
        switch (source.getDataType()) {
            case DT_NANOTIMESTAMP: {
                scaleFactor = 86400000000000L;
                BasicNanoTimestampVector ntsVec = (BasicNanoTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = (int)Utils.divide(ntsVec.getLong(i), scaleFactor);
                }
                return new BasicDateVector(values);
            }
            case DT_TIMESTAMP: {
                scaleFactor = 86400000L;
                BasicTimestampVector tsVec = (BasicTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = (int)Utils.divide(tsVec.getLong(i), scaleFactor);
                }
                return new BasicDateVector(values);
            }
            case DT_DATETIME: {
                scaleFactor = 86400L;
                BasicDateTimeVector dtVec = (BasicDateTimeVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.divide(dtVec.getInt(i), (int)scaleFactor);
                }
                return new BasicDateVector(values);
            }
        }
        throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, or DATETIME.");
    }

    public static Entity toDateHour(Entity source) {
        if (source.isScalar()) {
            long scaleFactor = 1L;
            switch (source.getDataType()) {
                case DT_DATETIME: {
                    scaleFactor = 3600L;
                    return new BasicDateHour(Utils.divide(((BasicDateTime)source).getInt(), (int)scaleFactor));
                }
                case DT_TIMESTAMP: {
                    scaleFactor = 3600000L;
                    return new BasicDateHour((int)Utils.divide(((BasicTimestamp)source).getLong(), scaleFactor));
                }
                case DT_NANOTIMESTAMP: {
                    scaleFactor = 3600000000000L;
                    return new BasicDateHour((int)Utils.divide(((BasicNanoTimestamp)source).getLong(), scaleFactor));
                }
            }
            throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, or DATETIME.");
        }
        long scaleFactor = 1L;
        int rows = source.rows();
        int[] values = new int[rows];
        switch (source.getDataType()) {
            case DT_DATETIME: {
                scaleFactor = 3600L;
                BasicDateTimeVector dtVec = (BasicDateTimeVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = Utils.divide(dtVec.getInt(i), (int)scaleFactor);
                }
                return new BasicDateHourVector(values);
            }
            case DT_TIMESTAMP: {
                scaleFactor = 3600000L;
                BasicTimestampVector tsVec = (BasicTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = (int)Utils.divide(tsVec.getLong(i), scaleFactor);
                }
                return new BasicDateHourVector(values);
            }
            case DT_NANOTIMESTAMP: {
                scaleFactor = 3600000000000L;
                BasicNanoTimestampVector ntsVec = (BasicNanoTimestampVector)source;
                for (int i = 0; i < rows; ++i) {
                    values[i] = (int)Utils.divide(ntsVec.getLong(i), scaleFactor);
                }
                return new BasicDateHourVector(values);
            }
        }
        throw new RuntimeException("The data type of the source data must be NANOTIMESTAMP, TIMESTAMP, or DATETIME.");
    }

    public static Entity castDateTime(Entity source, Entity.DATA_TYPE newDateTimeType) {
        if (source.getDataForm() != Entity.DATA_FORM.DF_VECTOR && source.getDataForm() != Entity.DATA_FORM.DF_SCALAR) {
            throw new RuntimeException("The source data must be a temporal scalar/vector.");
        }
        switch (newDateTimeType) {
            case DT_MONTH: {
                return Utils.toMonth(source);
            }
            case DT_DATE: {
                return Utils.toDate(source);
            }
            case DT_DATEHOUR: {
                return Utils.toDateHour(source);
            }
        }
        throw new RuntimeException("The target date/time type supports MONTH/DATE only for time being.");
    }

    public static ByteBuffer reAllocByteBuffer(ByteBuffer src, int size) {
        ByteBuffer ret = ByteBuffer.allocate(size).order(src.order());
        ret.put(src.array(), 0, src.position());
        return ret;
    }

    public static boolean isLittleEndian() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    public static boolean isVariableCandidate(String word) {
        char cur = word.charAt(0);
        if (!(cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z')) {
            return false;
        }
        for (int i = 1; i < word.length(); ++i) {
            cur = word.charAt(i);
            if (cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z' || cur >= '0' && cur <= '9' || cur == '_') continue;
            return false;
        }
        return true;
    }

    public static String getDataTypeString(Entity.DATA_TYPE dt) {
        switch (dt) {
            case DT_BOOL: {
                return "bool";
            }
            case DT_BYTE: {
                return "byte";
            }
            case DT_SHORT: {
                return "short";
            }
            case DT_INT: {
                return "int";
            }
            case DT_LONG: {
                return "long";
            }
            case DT_FLOAT: {
                return "float";
            }
            case DT_DOUBLE: {
                return "double";
            }
            case DT_NANOTIME: {
                return "nanotime";
            }
            case DT_NANOTIMESTAMP: {
                return "nanotimestamp";
            }
            case DT_TIMESTAMP: {
                return "timestamp";
            }
            case DT_DATE: {
                return "date";
            }
            case DT_MONTH: {
                return "month";
            }
            case DT_TIME: {
                return "time";
            }
            case DT_SECOND: {
                return "second";
            }
            case DT_MINUTE: {
                return "minute";
            }
            case DT_DATETIME: {
                return "datetime";
            }
            case DT_INT128: {
                return "int128";
            }
            case DT_IPADDR: {
                return "ipaddr";
            }
            case DT_UUID: {
                return "uuid";
            }
            case DT_STRING: {
                return "string";
            }
            case DT_SYMBOL: {
                return "symbol";
            }
            case DT_DECIMAL32: {
                return "decimal32";
            }
            case DT_DECIMAL64: {
                return "decimal64";
            }
        }
        return dt.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static void checkDecimal128Range(BigDecimal value, int scale) {
        if (Objects.isNull(value)) {
            throw new RuntimeException("Decimal value cannot be null.");
        }
        if (value.scaleByPowerOfTen(scale).compareTo(DECIMAL128_MIN_VALUE) < 0 || value.scaleByPowerOfTen(scale).compareTo(DECIMAL128_MAX_VALUE) > 0) {
            if (scale == 0) {
                throw new RuntimeException("Decimal128 overflow " + value.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP).toBigInteger());
            }
            throw new RuntimeException("Decimal128 overflow " + new BigDecimal(value.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP).toBigInteger()).scaleByPowerOfTen(-scale));
        }
    }

    public static class Timer {
        long start = 0L;
        long end = 0L;
        Map<String, ArrayList<Double>> runtime = new HashMap<String, ArrayList<Double>>();

        public void reset() {
            this.start = 0L;
            this.end = 0L;
            this.runtime = new HashMap<String, ArrayList<Double>>();
        }

        public void printAll() {
            for (Map.Entry<String, ArrayList<Double>> entry : this.runtime.entrySet()) {
                Double sum = 0.0;
                Double avg = 0.0;
                String prefix = entry.getKey();
                ArrayList<Double> times = entry.getValue();
                Double min = times.get(0);
                Double max = times.get(0);
                for (int i = 0; i < times.size(); ++i) {
                    Double time = times.get(i);
                    sum = sum + time;
                    if (min >= time) {
                        min = time;
                    }
                    if (!(max <= time)) continue;
                    max = time;
                }
                avg = sum / (double)times.size();
                log.info(prefix + "avg = " + avg + " min = " + min + " max = " + max);
            }
        }

        public void recordTime(String prefix, Long start, Long end) {
            this.start = start;
            this.end = end;
            ArrayList<Double> time = null;
            time = this.runtime.containsKey(prefix) ? this.runtime.get(prefix) : new ArrayList<Double>();
            time.add((double)(end - start) / 1000000.0);
            this.runtime.put(prefix, time);
        }
    }
}

