/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;

public class BasicMonth
extends BasicInt {
    public BasicMonth(int year, Month month) {
        super(year * 12 + month.getValue() - 1);
    }

    public BasicMonth(Calendar calendar) {
        super(calendar.get(1) * 12 + calendar.get(2));
    }

    public BasicMonth(YearMonth value) {
        super(value.getYear() * 12 + value.getMonthValue() - 1);
    }

    public BasicMonth(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public BasicMonth(int value) {
        super(value);
    }

    public YearMonth getMonth() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseMonth(this.getInt());
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MONTH;
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getMonth();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        YearMonth yearMonth = this.getMonth();
        if (yearMonth.getYear() == 0) {
            return "0000" + this.getMonth().format(DateTimeFormatter.ofPattern(".MM'M'"));
        }
        return this.getMonth().format(DateTimeFormatter.ofPattern("yyyy.MM'M'"));
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicMonth) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicMonth)o).getInt();
    }
}

