/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.Double2;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.io.OutputStream;

public class BigEndianDataOutputStream
extends AbstractExtendedDataOutputStream {
    public BigEndianDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(0xFF & v >> 8);
        this.write(0xFF & v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.write(0xFF & v >> 24);
        this.out.write(0xFF & v >> 16);
        this.out.write(0xFF & v >> 8);
        this.out.write(0xFF & v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.write((int)(0xFFL & v >> 56));
        this.out.write((int)(0xFFL & v >> 48));
        this.out.write((int)(0xFFL & v >> 40));
        this.out.write((int)(0xFFL & v >> 32));
        this.out.write((int)(0xFFL & v >> 24));
        this.out.write((int)(0xFFL & v >> 16));
        this.out.write((int)(0xFFL & v >> 8));
        this.out.write((int)(0xFFL & v));
    }

    @Override
    public void writeLong2(Long2 v) throws IOException {
        this.writeLong(v.high);
        this.writeLong(v.low);
    }

    @Override
    public void writeDouble2(Double2 v) throws IOException {
        this.writeDouble(v.x);
        this.writeDouble(v.y);
    }

    @Override
    public void writeShortArray(short[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            short v = A[i];
            if (pos + 2 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFF & v >> 8);
            this.buf[pos++] = (byte)(0xFF & v);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeIntArray(int[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            int v = A[i];
            if (pos + 4 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFF & v >> 24);
            this.buf[pos++] = (byte)(0xFF & v >> 16);
            this.buf[pos++] = (byte)(0xFF & v >> 8);
            this.buf[pos++] = (byte)(0xFF & v);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeLongArray(long[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            long v = A[i];
            if (pos + 8 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFFL & v >> 56);
            this.buf[pos++] = (byte)(0xFFL & v >> 48);
            this.buf[pos++] = (byte)(0xFFL & v >> 40);
            this.buf[pos++] = (byte)(0xFFL & v >> 32);
            this.buf[pos++] = (byte)(0xFFL & v >> 24);
            this.buf[pos++] = (byte)(0xFFL & v >> 16);
            this.buf[pos++] = (byte)(0xFFL & v >> 8);
            this.buf[pos++] = (byte)(0xFFL & v);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeLong2Array(Long2[] A, int startIdx, int len) throws IOException {
        if (this.longBuf == null) {
            this.longBuf = new long[512];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 512) {
                this.writeLongArray(this.longBuf, 0, pos);
                pos = 0;
            }
            this.longBuf[pos++] = A[i].high;
            this.longBuf[pos++] = A[i].low;
        }
        if (pos > 0) {
            this.writeLongArray(this.longBuf, 0, pos);
        }
    }

    @Override
    public void writeBigIntArray(byte[] A, int startIdx, int len) throws IOException {
        this.out.write(A);
    }
}

