/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.CryptoUtils;
import com.xxdb.RSAUtils;
import com.xxdb.comm.SqlStdEnum;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicDoubleVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTableSchema;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.io.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnection {
    private static final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private static final int MAX_TYPE_VALUE = Entity.DATA_TYPE.DT_DECIMAL128_ARRAY.getValue();
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_PARALLELISM = 64;
    private ReentrantLock mutex_;
    private DBConnectionImpl conn_;
    private String uid_;
    private String pwd_;
    private String initialScript_ = null;
    private boolean enableHighAvailability_;
    private List<Node> nodes_ = new ArrayList<Node>();
    private Random nodeRandom_ = new Random();
    private int connTimeout_ = 0;
    private int connectTimeout_ = 0;
    private int readTimeout_ = 0;
    private boolean closed_ = false;
    private boolean loadBalance_ = false;
    private String runClientId_ = null;
    private long runSeqNo_ = 0L;
    private int[] serverVersion_;
    private boolean isReverseStreaming_ = false;
    private int tryReconnectNums = -1;
    private static final Logger log = LoggerFactory.getLogger(DBConnection.class);

    private DBConnectionImpl createEnableReverseStreamingDBConnectionImpl(boolean asynTask, boolean sslEnable, boolean compress, boolean python, boolean ifUrgent, SqlStdEnum sqlStd) {
        return new DBConnectionImpl(asynTask, sslEnable, compress, python, ifUrgent, true, sqlStd, false);
    }

    public DBConnection() {
        this(false, false, false);
    }

    public DBConnection(SqlStdEnum sqlStd) {
        this(false, false, false, false, false, sqlStd);
    }

    public DBConnection(boolean asynchronousTask) {
        this(asynchronousTask, false, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL) {
        this(asynchronousTask, useSSL, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress) {
        this(asynchronousTask, useSSL, compress, false);
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, false, false, SqlStdEnum.DolphinDB, false);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, false, false, sqlStd, false);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, false, SqlStdEnum.DolphinDB, false);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, false, sqlStd, false);
        this.mutex_ = new ReentrantLock();
    }

    public DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, SqlStdEnum sqlStd, boolean enableSCRAM) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, false, sqlStd, enableSCRAM);
        this.mutex_ = new ReentrantLock();
    }

    @Deprecated
    private DBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, boolean isReverseStreaming, SqlStdEnum sqlStd) {
        this.conn_ = new DBConnectionImpl(asynchronousTask, useSSL, compress, usePython, isUrgent, isReverseStreaming, sqlStd, false);
        this.mutex_ = new ReentrantLock();
    }

    public static DBConnection internalCreateEnableReverseStreamingDBConnection(boolean asynchronousTask, boolean useSSL, boolean compress, boolean usePython, boolean isUrgent, SqlStdEnum sqlStd) {
        return new DBConnection(asynchronousTask, useSSL, compress, usePython, isUrgent, true, sqlStd);
    }

    public boolean isBusy() {
        if (!this.mutex_.tryLock()) {
            return true;
        }
        this.mutex_.unlock();
        return false;
    }

    private int getVersionNumber(String ver) {
        try {
            String[] s = ver.split(" ");
            if (s.length >= 2) {
                String vernum = s[0].replace(".", "");
                return Integer.parseInt(vernum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance_ = loadBalance;
    }

    public boolean connect(String hostName, int port) throws IOException {
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int connectTimeout, int readTimeout) throws IOException {
        if (connectTimeout < 0 || readTimeout < 0) {
            log.error("The param connectTimeout or readTimeout cannot less than zero.");
            return false;
        }
        this.connectTimeout_ = connectTimeout;
        this.readTimeout_ = readTimeout;
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout, boolean reconnect) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect);
    }

    public boolean connect(String hostName, int port, int connectTimeout, int readTimeout, boolean reconnect) throws IOException {
        if (connectTimeout < 0 || readTimeout < 0) {
            log.error("The param connectTimeout or readTimeout cannot less than zero.");
            return false;
        }
        this.connectTimeout_ = connectTimeout;
        this.readTimeout_ = readTimeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect);
    }

    public boolean connect(String hostName, int port, int timeout, boolean reconnect, int tryReconnectNums) throws IOException {
        this.connTimeout_ = timeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect, tryReconnectNums);
    }

    public boolean connect(String hostName, int port, int connectTimeout, int readTimeout, boolean reconnect, int tryReconnectNums) throws IOException {
        if (connectTimeout < 0 || readTimeout < 0) {
            log.error("The param connectTimeout or readTimeout cannot less than zero.");
            return false;
        }
        this.connectTimeout_ = connectTimeout;
        this.readTimeout_ = readTimeout;
        return this.connect(hostName, port, "", "", null, false, null, reconnect, tryReconnectNums);
    }

    public boolean connect(String hostName, int port, String initialScript) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, "", "", null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password) throws IOException {
        return this.connect(hostName, port, userId, password, null, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, null, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, false);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect) throws IOException {
        if (enableHighAvailability) {
            return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, true);
        }
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, false);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect, int tryReconnectNums) throws IOException {
        if (enableHighAvailability) {
            return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, true, tryReconnectNums);
        }
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, false, tryReconnectNums);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect, boolean enableLoadBalance) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, enableLoadBalance, -1);
    }

    public boolean connect(ConnectConfig connectConfig) throws IOException {
        this.connectTimeout_ = connectConfig.getConnectTimeout();
        this.readTimeout_ = connectConfig.getReadTimeout();
        return this.connect(connectConfig.getHostName(), connectConfig.getPort(), connectConfig.getUserId(), connectConfig.getPassword(), connectConfig.getInitialScript(), connectConfig.getEnableHighAvailability(), connectConfig.getHighAvailabilitySites(), connectConfig.getReconnect(), connectConfig.getEnableLoadBalance(), connectConfig.getTryReconnectNums());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect, boolean enableLoadBalance, int tryReconnectNums) throws IOException {
        this.mutex_.lock();
        try {
            this.uid_ = userId;
            this.pwd_ = password;
            this.initialScript_ = initialScript;
            this.enableHighAvailability_ = enableHighAvailability;
            this.loadBalance_ = enableLoadBalance;
            this.tryReconnectNums = tryReconnectNums <= 0 ? -1 : tryReconnectNums;
            if (this.loadBalance_ && !this.enableHighAvailability_) {
                throw new RuntimeException("Cannot only enable loadbalance but not enable highAvailablity.");
            }
            if (enableHighAvailability) {
                int totalConnectAttemptNums;
                this.nodes_.add(new Node(hostName, port));
                if (highAvailabilitySites != null) {
                    for (String site : highAvailabilitySites) {
                        Node node = new Node(site);
                        if (this.nodes_.contains(node)) continue;
                        this.nodes_.add(node);
                    }
                }
                Node connectedNode = new Node();
                BasicTable bt = null;
                while (!this.closed_) {
                    totalConnectAttemptNums = this.tryReconnectNums * this.nodes_.size();
                    int attempt = 0;
                    block18: while (!this.conn_.isConnected() && !this.closed_) {
                        if (this.tryReconnectNums > 0) {
                            for (Node one : this.nodes_) {
                                ++attempt;
                                if (this.connectNode(one)) {
                                    connectedNode = one;
                                    break;
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    boolean bl = false;
                                    this.mutex_.unlock();
                                    return bl;
                                }
                            }
                            if (attempt != totalConnectAttemptNums) continue;
                            log.error("Connect failed after " + tryReconnectNums + " reconnect attempts for every node in high availability sites.");
                            boolean node = false;
                            return node;
                        }
                        for (Node one : this.nodes_) {
                            if (this.connectNode(one)) {
                                connectedNode = one;
                                continue block18;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                boolean bl = false;
                                this.mutex_.unlock();
                                return bl;
                            }
                        }
                    }
                    try {
                        BasicBoolean isClientAuth = null;
                        try {
                            isClientAuth = (BasicBoolean)this.conn_.run("isClientAuth", new ArrayList(), 0L);
                        }
                        catch (Exception e) {
                            if (e.getMessage().contains("Can't recognize function name isClientAuth")) {
                                bt = (BasicTable)this.conn_.run("rpc(getControllerAlias(),getClusterPerf)", 0L);
                                break;
                            }
                            throw e;
                        }
                        if (isClientAuth.getBoolean()) {
                            bt = (BasicTable)this.conn_.run("getClusterPerf", new ArrayList(), 0L);
                            break;
                        }
                        bt = (BasicTable)this.conn_.run("rpc(getControllerAlias(),getClusterPerf)", 0L);
                        break;
                    }
                    catch (Exception e) {
                        log.error("ERROR getting other data nodes, exception: " + e.getMessage());
                        Node node1 = new Node();
                        if (this.isConnected()) {
                            ExceptionType type = this.parseException(e.getMessage(), node1);
                            if (type == ExceptionType.ET_IGNORE || type != ExceptionType.ET_NEWLEADER && type != ExceptionType.ET_NODENOTAVAIL) continue;
                            this.switchDataNode(node1);
                            continue;
                        }
                        this.switchDataNode(node1);
                    }
                }
                if (this.closed_) {
                    totalConnectAttemptNums = 0;
                    return totalConnectAttemptNums != 0;
                }
                if (bt != null && bt.getDataForm() != Entity.DATA_FORM.DF_TABLE) {
                    throw new IOException("Run getClusterPerf() failed.");
                }
                if (bt != null) {
                    if (!this.loadBalance_) {
                        if (highAvailabilitySites == null) {
                            BasicStringVector colHost = (BasicStringVector)bt.getColumn("host");
                            BasicIntVector colPort = (BasicIntVector)bt.getColumn("port");
                            for (int i = 0; i < colHost.rows(); ++i) {
                                Node curNode = new Node(colHost.getString(i), colPort.getInt(i));
                                if (curNode.hostName.equals(hostName) && curNode.port == port) continue;
                                this.nodes_.add(curNode);
                            }
                        }
                    } else {
                        ArrayList<Node> lowLoadNodes = new ArrayList<Node>();
                        BasicIntVector mode = (BasicIntVector)bt.getColumn("mode");
                        BasicStringVector colHost = (BasicStringVector)bt.getColumn("host");
                        BasicIntVector colPort = (BasicIntVector)bt.getColumn("port");
                        BasicLongVector memoryUsed = (BasicLongVector)bt.getColumn("memoryUsed");
                        BasicDoubleVector maxMemSize = (BasicDoubleVector)bt.getColumn("maxMemSize");
                        BasicIntVector connectionNum = (BasicIntVector)bt.getColumn("connectionNum");
                        BasicIntVector maxConnections = (BasicIntVector)bt.getColumn("maxConnections");
                        BasicDoubleVector avgLoad = (BasicDoubleVector)bt.getColumn("avgLoad");
                        for (int i = 0; i < colHost.rows(); ++i) {
                            if (mode.getInt(i) != 0) continue;
                            Node nodex = new Node(colHost.getString(i), colPort.getInt(i));
                            Node pexistNode = null;
                            if (highAvailabilitySites != null) {
                                for (Node node : this.nodes_) {
                                    if (!node.hostName.equals(nodex.hostName) && !nodex.hostName.equals("localhost") || node.port != nodex.port) continue;
                                    pexistNode = node;
                                    break;
                                }
                                if (pexistNode == null) continue;
                            }
                            double memLoad = (double)memoryUsed.getLong(i) / 1024.0 / 1024.0 / 1024.0 / maxMemSize.getDouble(i);
                            double connLoad = (double)connectionNum.getInt(i) * 1.0 / (double)maxConnections.getInt(i);
                            double load = (memLoad + connLoad + avgLoad.getDouble(i)) / 3.0;
                            if (pexistNode != null) {
                                pexistNode.load = load;
                            } else {
                                pexistNode = new Node(colHost.getString(i), colPort.getInt(i), load);
                                this.nodes_.add(pexistNode);
                            }
                            if (!(memLoad < 0.8) || !(connLoad < 0.9) || !(avgLoad.getDouble(i) < 0.8)) continue;
                            lowLoadNodes.add(pexistNode);
                        }
                        Node pMinNode = !lowLoadNodes.isEmpty() ? (Node)lowLoadNodes.get(this.nodeRandom_.nextInt(lowLoadNodes.size())) : this.nodes_.get(this.nodeRandom_.nextInt(this.nodes_.size()));
                        if (pMinNode != null && !pMinNode.equals(connectedNode)) {
                            log.info("Switch to node: " + pMinNode.hostName + ":" + pMinNode.port);
                            this.conn_.close();
                            this.switchDataNode(pMinNode);
                        }
                    }
                }
            } else if (reconnect) {
                this.nodes_.clear();
                this.nodes_.add(new Node(hostName, port));
                this.switchDataNode(new Node(hostName, port));
            } else if (!this.connectNode(new Node(hostName, port))) {
                boolean bl = false;
                return bl;
            }
            this.initConnection();
            boolean bl = true;
            return bl;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    private void initConnection() throws IOException {
        this.runClientId_ = null;
        if (this.enableHighAvailability_ && this.getServerVersion() && this.checkClientIdValid()) {
            this.runClientId_ = BasicUuid.random().getString();
            this.runSeqNo_ = 0L;
        }
        if (this.initialScript_ != null && this.initialScript_.length() > 0) {
            this.run(this.initialScript_);
        }
    }

    public void switchDataNode(Node node) throws IOException {
        int attempt = 0;
        boolean isConnected = false;
        do {
            int index;
            ++attempt;
            if (node.hostName != null && node.hostName.length() > 0 && this.connectNode(node)) {
                if (this.nodes_.size() > 1) {
                    log.info("Switch to node: " + node.hostName + ":" + node.port + " successfully.");
                }
                isConnected = true;
                break;
            }
            if (this.nodes_.isEmpty()) {
                log.error("Connect to " + node.hostName + ":" + node.port + " failed.");
                throw new RuntimeException("Connect to " + node.hostName + ":" + node.port + " failed.");
            }
            if (this.nodes_.size() > 1 && this.connectNode(this.nodes_.get(index = this.nodeRandom_.nextInt(this.nodes_.size())))) {
                log.info("Switch to node: " + this.nodes_.get(index).hostName + ":" + this.nodes_.get(index).port + " successfully.");
                isConnected = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } while (!this.closed_ && (this.tryReconnectNums == -1 || attempt < this.tryReconnectNums));
        if (!this.closed_ && !isConnected) {
            log.error("Connect to " + node.hostName + ":" + node.port + " failed after " + attempt + " reconnect attempts.");
            throw new RuntimeException("Connect to " + node.hostName + ":" + node.port + " failed after " + attempt + " reconnect attempts.");
        }
        if (this.initialScript_ != null && this.initialScript_.length() > 0) {
            this.run(this.initialScript_);
        }
    }

    public boolean connectNode(Node node) throws IOException {
        log.info("Connect to " + node.hostName + ":" + node.port + ".");
        while (!this.closed_) {
            try {
                boolean nodeInited;
                boolean connected = this.conn_.connect(node.hostName, node.port, this.uid_, this.pwd_, this.connTimeout_, this.connectTimeout_, this.readTimeout_);
                if (!connected) {
                    return false;
                }
                try {
                    nodeInited = ((BasicBoolean)this.conn_.run("isNodeInitialized", new ArrayList(), 0L)).getBoolean();
                }
                catch (Exception e) {
                    log.error("Server does not support the initialization check. Please upgrade to a newer version.");
                    nodeInited = true;
                }
                return nodeInited;
            }
            catch (Exception e) {
                if (this.isConnected()) {
                    Node tmpNode = new Node();
                    tmpNode.hostName = node.hostName;
                    tmpNode.port = node.port;
                    ExceptionType type = this.parseException(e.getMessage(), tmpNode);
                    if (type != ExceptionType.ET_NEWLEADER) {
                        if (type == ExceptionType.ET_IGNORE) {
                            return true;
                        }
                        if (type == ExceptionType.ET_NODENOTAVAIL) {
                            return false;
                        }
                        throw e;
                    }
                } else {
                    if (Objects.nonNull(e.getMessage())) {
                        log.error(e.getMessage());
                    }
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public ExceptionType parseException(String msg, Node node) {
        if (msg == null) {
            node.hostName = "";
            node.port = 0;
            return ExceptionType.ET_UNKNOW;
        }
        int index = msg.indexOf("<NotLeader>");
        if (index != -1) {
            index = msg.indexOf(">");
            String ipport = msg.substring(index + 1);
            if (!Pattern.matches("\\d+", ipport)) {
                log.error("The control node you are accessing is not the leader node of the highly available (raft) cluster.");
                return ExceptionType.ET_NOTLEADER;
            }
            this.parseIpPort(ipport, node);
            log.info("New leader is " + node.hostName + ":" + node.port);
            return ExceptionType.ET_NEWLEADER;
        }
        index = msg.indexOf("<DataNodeNotAvail>");
        if (index != -1) {
            index = msg.indexOf(">");
            String ipport = msg.substring(index + 1);
            Node newNode = new Node();
            this.parseIpPort(ipport, newNode);
            Node lastNode = new Node();
            this.conn_.getNode(lastNode);
            node.hostName = "";
            node.port = 0;
            log.info(msg);
            return ExceptionType.ET_NODENOTAVAIL;
        }
        index = msg.indexOf("The datanode isn't initialized yet. Please try again later");
        if (index != -1) {
            node.hostName = "";
            node.port = 0;
            return ExceptionType.ET_NOINITIALIZED;
        }
        if (msg.contains("Read timed out")) {
            this.conn_.getNode(node);
            return ExceptionType.ET_READTIMEDOUT;
        }
        if (msg.contains("Failed to read response header from the socket with IO error null")) {
            this.conn_.getNode(node);
            return ExceptionType.ET_NORESPONSEHEADER;
        }
        if (msg.contains("Login is required for script execution with client authentication enabled")) {
            this.conn_.getNode(node);
            return ExceptionType.ET_LOGINREQUIRED;
        }
        node.hostName = "";
        node.port = 0;
        return ExceptionType.ET_UNKNOW;
    }

    public void parseIpPort(String ipport, Node node) {
        String[] v = ipport.split(":");
        if (v.length < 2) {
            throw new RuntimeException("The ipPort '" + ipport + "' is invalid.");
        }
        node.hostName = v[0];
        node.port = Integer.parseInt(v[1]);
    }

    public boolean connected() {
        try {
            this.conn_.run("version", new ArrayList(), 0L);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(String userId, String password, boolean enableEncryption) throws IOException {
        this.conn_.login(userId, password, enableEncryption);
        this.uid_ = userId;
        this.pwd_ = password;
    }

    public boolean getRemoteLittleEndian() {
        return this.conn_.getRemoteLittleEndian();
    }

    public Entity tryRun(String script) throws IOException {
        return this.tryRun(script, 4, 64);
    }

    public Entity tryRun(String script, int priority, int parallelism) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, false);
    }

    public Entity tryRun(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.tryRun(script, priority, parallelism, 0, clearSessionMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, (ProgressListener)null, priority, parallelism, fetchSize, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, String tableName) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 64, 0, false, tableName);
    }

    public Entity run(String script) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 64);
    }

    public Entity run(String script, int priority) throws IOException {
        return this.run(script, (ProgressListener)null, priority, 64);
    }

    public Entity run(String script, int priority, int parallelism) throws IOException {
        return this.run(script, (ProgressListener)null, priority, parallelism);
    }

    public Entity run(String script, ProgressListener listener) throws IOException {
        return this.run(script, listener, 4, 64);
    }

    public Entity run(String script, ProgressListener listener, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, 4, 64, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, boolean clearSessionMemory) throws IOException {
        return this.run(script, (ProgressListener)null, priority, 64, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, false);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, int priority, int parallelism, boolean clearSessionMemory) throws IOException {
        return this.run(script, (ProgressListener)null, priority, parallelism, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, boolean clearSessionMemory) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, (ProgressListener)null, 4, 64, 0, clearSessionMemory);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String script, boolean clearSessionMemory) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 64, 0, clearSessionMemory);
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory, String tableName, boolean enableSeqNo) throws IOException {
        this.mutex_.lock();
        try {
            block15: {
                if (this.nodes_.isEmpty()) break block15;
                long currentSeqNo = enableSeqNo ? this.newSeqNo() : 0L;
                while (!this.closed_) {
                    try {
                        Entity entity = this.conn_.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName, currentSeqNo);
                        return entity;
                    }
                    catch (IOException e) {
                        Node node;
                        block16: {
                            ExceptionType type;
                            block13: {
                                block14: {
                                    if (currentSeqNo > 0L) {
                                        currentSeqNo = -currentSeqNo;
                                    }
                                    node = new Node();
                                    if (!this.connected()) break block13;
                                    type = this.parseException(e.getMessage(), node);
                                    if (type == ExceptionType.ET_IGNORE) {
                                        Void void_ = new Void();
                                        this.mutex_.unlock();
                                        return void_;
                                    }
                                    if (type != ExceptionType.ET_UNKNOW && type != ExceptionType.ET_LOGINREQUIRED) break block14;
                                    throw e;
                                }
                                if (type == ExceptionType.ET_READTIMEDOUT) {
                                    this.cancelConsoleJob(enableSeqNo, currentSeqNo, e);
                                }
                                break block16;
                            }
                            type = this.parseException(e.getMessage(), node);
                            if (type == ExceptionType.ET_READTIMEDOUT) {
                                this.cancelConsoleJob(enableSeqNo, currentSeqNo, e);
                            }
                        }
                        this.switchDataNode(node);
                    }
                }
                Entity entity = null;
                return entity;
            }
            Entity entity = this.conn_.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName, 0L);
            return entity;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    private void cancelConsoleJob(boolean enableSeqNo, long currentSeqNo, IOException e) throws IOException {
        String cancelConsoleJobScript = "jobs = exec rootJobId from getConsoleJobs() where sessionId = " + this.conn_.sessionID_ + "\n" + (this.conn_.python_ ? "if size(jobs):\n" : "if (size(jobs))\n") + "    cancelConsoleJob(jobs)\n";
        this.conn_.ifUrgent_ = true;
        if (enableSeqNo) {
            currentSeqNo = this.newSeqNo();
        }
        try {
            this.conn_.run(cancelConsoleJobScript, currentSeqNo);
            this.conn_.ifUrgent_ = false;
        }
        catch (IOException ioe) {
            this.conn_.ifUrgent_ = false;
            throw new RuntimeException("Execute cancelConsoleJob failed after current connnection read timed out. ");
        }
        log.error(e.getMessage());
        throw e;
    }

    public Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearSessionMemory, String tableName) throws IOException {
        return this.run(script, listener, priority, parallelism, fetchSize, clearSessionMemory, tableName, true);
    }

    public Entity tryRun(String function, List<Entity> arguments) throws IOException {
        return this.tryRun(function, arguments, 4, 64);
    }

    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.tryRun(function, arguments, priority, parallelism, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        if (!this.mutex_.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(function, arguments, priority, parallelism, fetchSize);
            return entity;
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.run(function, arguments, 4, 64);
    }

    public Entity run(String function, List<Entity> arguments, int priority) throws IOException {
        return this.run(function, arguments, priority, 64);
    }

    public Entity run(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        return this.run(function, arguments, priority, parallelism, 0);
    }

    private long newSeqNo() {
        this.mutex_.lock();
        ++this.runSeqNo_;
        if (this.runSeqNo_ <= 0L) {
            this.runSeqNo_ = 1L;
        }
        long res = this.runSeqNo_;
        this.mutex_.unlock();
        return res;
    }

    public Entity run(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize, boolean enableSeqNo) throws IOException {
        return this.run(function, arguments, priority, parallelism, fetchSize, enableSeqNo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Entity run(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize, boolean enableSeqNo, ProgressListener listener) throws IOException {
        this.mutex_.lock();
        try {
            if (!this.nodes_.isEmpty()) {
                currentSeqNo = enableSeqNo != false ? this.newSeqNo() : 0L;
                while (!this.closed_) {
                    try {
                        var10_11 = DBConnectionImpl.access$3300(this.conn_, function, listener, arguments, priority, parallelism, fetchSize, false, currentSeqNo);
                        return var10_11;
                    }
                    catch (IOException e) {
                        block14: {
                            block13: {
                                if (currentSeqNo > 0L) {
                                    currentSeqNo = -currentSeqNo;
                                }
                                node = new Node();
                                if (!this.connected()) break block13;
                                type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) {
                                    var13_15 = new Void();
                                    this.mutex_.unlock();
                                    return var13_15;
                                }
                                ** if (type != ExceptionType.ET_UNKNOW) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    throw e;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    break block14;
                                }
                            }
                            this.parseException(e.getMessage(), node);
                        }
                        this.switchDataNode(node);
                    }
                }
                var10_12 = null;
                return var10_12;
            }
            var8_9 = DBConnectionImpl.access$3300(this.conn_, function, listener, arguments, priority, parallelism, fetchSize, false, 0L);
            return var8_9;
            {
                catch (Throwable var14_16) {
                    throw var14_16;
                }
            }
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments, int priority, int parallelism, int fetchSize) throws IOException {
        return this.run(function, arguments, priority, parallelism, fetchSize, true);
    }

    public void tryUpload(Map<String, Entity> variableObjectMap) throws IOException {
        if (!this.mutex_.tryLock()) {
            throw new IOException("The connection is in use.");
        }
        try {
            this.upload(variableObjectMap);
        }
        finally {
            this.mutex_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Map<String, Entity> variableObjectMap) throws IOException {
        block16: {
            this.mutex_.lock();
            try {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<Entity> objs = new ArrayList<Entity>();
                if (!this.nodes_.isEmpty()) {
                    while (!this.closed_) {
                        try {
                            for (String key : variableObjectMap.keySet()) {
                                if (variableObjectMap.size() == 1) {
                                    Entity obj = variableObjectMap.get(key);
                                    this.conn_.upload(key, obj, 0L);
                                    continue;
                                }
                                keys.add(key);
                                objs.add(variableObjectMap.get(key));
                            }
                            if (variableObjectMap.size() > 1) {
                                this.conn_.upload(keys, objs, 0L);
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            Node node = new Node();
                            if (this.connected()) {
                                ExceptionType type = this.parseException(e.getMessage(), node);
                                if (type == ExceptionType.ET_IGNORE) continue;
                                if (type == ExceptionType.ET_UNKNOW) {
                                    throw e;
                                }
                            } else {
                                this.parseException(e.getMessage(), node);
                            }
                            this.switchDataNode(node);
                        }
                    }
                    break block16;
                }
                for (String key : variableObjectMap.keySet()) {
                    if (variableObjectMap.size() == 1) {
                        Entity obj = variableObjectMap.get(key);
                        this.conn_.upload(key, obj, 0L);
                        continue;
                    }
                    keys.add(key);
                    objs.add(variableObjectMap.get(key));
                }
                if (variableObjectMap.size() > 1) {
                    this.conn_.upload(keys, objs, 0L);
                }
            }
            finally {
                this.mutex_.unlock();
            }
        }
    }

    public void close() {
        this.mutex_.lock();
        try {
            this.closed_ = true;
            this.conn_.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mutex_.unlock();
        }
    }

    public String getHostName() {
        return this.conn_.hostName_;
    }

    public int getPort() {
        return this.conn_.port_;
    }

    public String getUserId() {
        return this.conn_.userId_;
    }

    public String getPwd() {
        return this.conn_.pwd_;
    }

    public String getSessionID() {
        return this.conn_.sessionID_;
    }

    public InetAddress getLocalAddress() {
        return this.conn_.socket_.getLocalAddress();
    }

    public Socket getSocket() {
        return this.conn_.socket_;
    }

    public ExtendedDataInput getDataInputStream() {
        return this.conn_.getDataInputStream();
    }

    public boolean isConnected() {
        return this.conn_.socket_ != null && this.conn_.socket_.isConnected();
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean getServerVersion() throws IOException {
        try {
            Entity ret = this.conn_.run("version", new ArrayList(), 0L);
            if (ret == null) {
                throw new IOException("run version failed");
            }
            String version = ret.getString();
            String[] verList = version.split(" ");
            if (verList.length > 1) {
                version = verList[0];
            }
            verList = version.split("\\.");
            this.serverVersion_ = new int[4];
            int size = verList.length;
            if (size > 4) {
                size = 4;
            } else if (size < 3) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                this.serverVersion_[i] = Integer.parseInt(verList[i]);
            }
        }
        catch (Exception e) {
            throw new IOException("Run version failed error: " + e.getMessage());
        }
        return true;
    }

    private boolean compareVersionGE(int[] version) {
        for (int i = 0; i < version.length; ++i) {
            if (this.serverVersion_[i] == version[i]) continue;
            return this.serverVersion_[i] > version[i];
        }
        return true;
    }

    private boolean checkClientIdValid() {
        if (this.serverVersion_[0] == 1) {
            return this.compareVersionGE(new int[]{1, 30, 20, 5});
        }
        if (this.serverVersion_[0] == 2) {
            return this.compareVersionGE(new int[]{2, 0, 9, 0});
        }
        return true;
    }

    private class DBConnectionImpl {
        private Socket socket_;
        private String sessionID_ = "";
        private String hostName_;
        private int port_;
        private String userId_;
        private String pwd_;
        private boolean encrypted_ = true;
        private boolean enableSCRAM;
        private boolean isConnected_;
        private boolean sslEnable_ = false;
        private boolean asynTask_ = false;
        private boolean compress_ = false;
        private boolean ifUrgent_ = false;
        private int connTimeout_ = 0;
        private int connectTimeout_ = 0;
        private int readTimeout_ = 0;
        private ExtendedDataInput in_;
        private ExtendedDataOutput out_;
        private boolean remoteLittleEndian_;
        private ReentrantLock lock_;
        private boolean isReverseStreaming_ = false;
        private boolean python_ = false;
        private SqlStdEnum sqlStd_;

        private DBConnectionImpl(boolean asynTask, boolean sslEnable, boolean compress, boolean python, boolean ifUrgent, boolean isReverseStreaming, SqlStdEnum sqlStd, boolean enableSCRAM) {
            this.sslEnable_ = sslEnable;
            this.asynTask_ = asynTask;
            this.compress_ = compress;
            this.ifUrgent_ = ifUrgent;
            this.python_ = python;
            this.isReverseStreaming_ = isReverseStreaming;
            this.sqlStd_ = sqlStd;
            this.lock_ = new ReentrantLock();
            this.enableSCRAM = enableSCRAM;
        }

        private boolean connect(String hostName, int port, String userId, String password, int connTimeout, int connectTimeout, int readTimeout) throws IOException {
            this.hostName_ = hostName;
            this.port_ = port;
            this.userId_ = userId;
            this.pwd_ = password;
            this.connTimeout_ = connTimeout;
            this.connectTimeout_ = connectTimeout;
            this.readTimeout_ = readTimeout;
            return this.connect();
        }

        private boolean connect() throws IOException {
            this.isConnected_ = false;
            try {
                this.socket_ = this.sslEnable_ ? DBConnection.this.getSSLSocketFactory().createSocket() : new Socket();
                if (this.connTimeout_ > 0 && this.connectTimeout_ == 0) {
                    this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), this.connTimeout_);
                } else if (this.connTimeout_ > 0 && this.connectTimeout_ > 0) {
                    this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), this.connectTimeout_);
                } else if (this.connTimeout_ == 0 && this.connectTimeout_ > 0) {
                    this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), this.connectTimeout_);
                } else if (this.connTimeout_ == 0 && this.connectTimeout_ == 0) {
                    this.socket_.connect(new InetSocketAddress(this.hostName_, this.port_), 3000);
                }
            }
            catch (IOException ex) {
                log.error("Connect to " + this.hostName_ + ":" + this.port_ + " failed.");
                throw ex;
            }
            if (this.connTimeout_ > 0 && this.readTimeout_ == 0) {
                this.socket_.setSoTimeout(this.connTimeout_);
            } else if (this.connTimeout_ > 0 && this.readTimeout_ > 0) {
                this.socket_.setSoTimeout(this.readTimeout_);
            } else if (this.connTimeout_ == 0 && this.readTimeout_ > 0) {
                this.socket_.setSoTimeout(this.readTimeout_);
            }
            this.socket_.setKeepAlive(true);
            this.socket_.setTcpNoDelay(true);
            this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            this.in_ = new LittleEndianDataInputStream(new BufferedInputStream(this.socket_.getInputStream()));
            String body = "connect\n";
            this.out_.writeBytes("API 0 ");
            this.out_.writeBytes(String.valueOf(body.length()));
            int flag = this.generateRequestFlag(false);
            this.out_.writeBytes(" / " + String.valueOf(flag) + "_1_" + String.valueOf(4) + "_" + String.valueOf(2));
            this.out_.writeByte(10);
            this.out_.writeBytes(body);
            this.out_.flush();
            String line = this.in_.readLine();
            int endPos = line.indexOf(32);
            if (endPos <= 0) {
                this.close();
                return false;
            }
            this.sessionID_ = line.substring(0, endPos);
            int startPos = endPos + 1;
            if ((endPos = line.indexOf(32, startPos)) != line.length() - 2) {
                this.close();
                return false;
            }
            String msg = this.in_.readLine();
            this.isConnected_ = true;
            if (line.charAt(endPos + 1) == '0') {
                this.remoteLittleEndian_ = false;
                this.out_ = new BigEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            } else {
                this.remoteLittleEndian_ = true;
            }
            if (!this.userId_.isEmpty() && !this.pwd_.isEmpty()) {
                if (this.asynTask_) {
                    this.login(this.userId_, this.pwd_, false);
                } else {
                    this.login(this.userId_, this.pwd_, this.encrypted_);
                }
            }
            log.info("Connect to " + this.hostName_ + ":" + this.port_ + " successfully.");
            return true;
        }

        private int generateRequestFlag(boolean clearSessionMemory) {
            int flag = 0;
            if (this.ifUrgent_) {
                ++flag;
            }
            if (this.asynTask_) {
                flag += 4;
            }
            if (clearSessionMemory) {
                flag += 16;
            }
            if (this.compress_) {
                flag += 64;
            }
            if (this.python_) {
                flag += 2048;
            }
            if (this.isReverseStreaming_) {
                flag += 131072;
            }
            if (Objects.nonNull((Object)this.sqlStd_)) {
                flag += this.sqlStd_.getCode() << 19;
            }
            return flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void login(String userId, String password, boolean enableEncryption) throws IOException {
            this.lock_.lock();
            this.userId_ = userId;
            this.pwd_ = password;
            if (this.enableSCRAM) {
                try {
                    this.scramLogin();
                }
                finally {
                    this.lock_.unlock();
                }
            }
            try {
                this.scramLogin();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.encrypted_ = enableEncryption;
                this.login();
            }
            finally {
                this.lock_.unlock();
            }
        }

        private void scramLogin() throws IOException {
            Entity result;
            if (this.asynTask_) {
                throw new IOException("SCRAM login is not supported in async mode.");
            }
            ArrayList<Entity> args = new ArrayList<Entity>();
            args.add(new BasicString(this.userId_));
            String clientNonce = CryptoUtils.generateNonce(16);
            args.add(new BasicString(clientNonce));
            try {
                result = this.run("scramClientFirst", args, 0L);
            }
            catch (IOException e) {
                if (e.getMessage().contains("Can't recognize function name scramClientFirst")) {
                    throw new IOException("SCRAM login is unavailble on current server.");
                }
                if (e.getMessage().contains("sha256 authMode doesn't support scram authMode")) {
                    throw new IOException("user '" + this.userId_ + "' doesn't support scram authMode.");
                }
                throw e;
            }
            if (!result.isVector() || result.rows() != 3) {
                throw new IOException("SCRAM login failed, server error: get server nonce failed.");
            }
            String saltString = ((Vector)result).get(0).getString();
            byte[] salt = CryptoUtils.base64Decode(saltString, false);
            int iterCount = ((BasicInt)((Vector)result).get(1)).getInt();
            String combinedNonce = ((Vector)result).get(2).getString();
            byte[] saltedPassword = CryptoUtils.pbkdf2HmacSha256(this.pwd_, salt, iterCount);
            byte[] clientKey = CryptoUtils.computeClientKey(saltedPassword);
            byte[] storedKey = CryptoUtils.computeStoredKey(clientKey);
            String authMessage = "n=" + this.userId_ + ",r=" + clientNonce + ",r=" + combinedNonce + ",s=" + saltString + ",i=" + iterCount + ",c=biws,r=" + combinedNonce;
            byte[] clientSignature = CryptoUtils.computeClientSignature(storedKey, authMessage);
            byte[] proof = CryptoUtils.computeProof(clientKey, clientSignature);
            args.clear();
            args.add(new BasicString(this.userId_));
            args.add(new BasicString(combinedNonce));
            args.add(new BasicString(CryptoUtils.base64Encode(proof, false)));
            result = this.run("scramClientFinal", args, 0L);
            if (!result.isScalar() || result.getDataType() != Entity.DATA_TYPE.DT_STRING) {
                throw new IOException("SCRAM login failed, server error: get server signature failed.");
            }
            byte[] serverKey = CryptoUtils.computeServerKey(saltedPassword);
            byte[] serverSignature = CryptoUtils.computeServerSignature(serverKey, authMessage);
            if (!result.getString().isEmpty() && !CryptoUtils.base64Encode(serverSignature, false).equals(result.getString())) {
                this.close();
                throw new IOException("SCRAM login failed, Invalid server signature");
            }
            log.info("SCRAM login succeed.");
        }

        private void login() throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            if (this.encrypted_) {
                BasicString keyCode = (BasicString)this.run("getDynamicPublicKey", new ArrayList<Entity>(), 0L);
                PublicKey key = RSAUtils.getPublicKey(keyCode.getString());
                byte[] usr = RSAUtils.encryptByPublicKey(this.userId_.getBytes(), key);
                byte[] pass = RSAUtils.encryptByPublicKey(this.pwd_.getBytes(), key);
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(usr)));
                args.add(new BasicString(Base64.getMimeEncoder().encodeToString(pass)));
                args.add(new BasicBoolean(true));
            } else {
                args.add(new BasicString(this.userId_));
                args.add(new BasicString(this.pwd_));
            }
            this.run("login", args, 0L);
        }

        private Entity run(String script, long seqNum) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", null, args, 4, 64, 0, false, seqNum);
        }

        private Entity run(String script, ProgressListener listener, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName, long seqNum) throws IOException {
            ArrayList<Entity> args = new ArrayList<Entity>();
            return this.run(script, "script", listener, args, priority, parallelism, fetchSize, clearMemory, tableName, seqNum);
        }

        private Entity run(String function, List<Entity> arguments, long seqNum) throws IOException {
            return this.run(function, "function", null, arguments, 4, 64, 0, false, seqNum);
        }

        private Entity run(String function, String scriptType, List<Entity> arguments, long seqNum) throws IOException {
            return this.run(function, scriptType, null, arguments, 4, 64, 0, false, seqNum);
        }

        private Entity run(String function, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, long seqNum) throws IOException {
            return this.run(function, "function", listener, args, priority, parallelism, fetchSize, clearMemory, seqNum);
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, long seqNum) throws IOException {
            return this.run(script, scriptType, listener, args, priority, parallelism, fetchSize, clearMemory, "", seqNum);
        }

        private Entity run(String script, String scriptType, ProgressListener listener, List<Entity> args, int priority, int parallelism, int fetchSize, boolean clearMemory, String tableName, long seqNum) throws IOException {
            if (!this.isConnected_) {
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (fetchSize > 0 && fetchSize < 8192) {
                throw new IOException("fetchSize must be greater than 8192");
            }
            if (this.socket_ == null || !this.socket_.isConnected() || this.socket_.isClosed()) {
                if (this.sessionID_.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                this.socket_ = new Socket(this.hostName_, this.port_);
                this.socket_.setKeepAlive(true);
                this.socket_.setTcpNoDelay(true);
                this.out_ = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket_.getOutputStream()));
            }
            if (!tableName.equals("")) {
                script = tableName + "=" + script;
                this.run(script, 0L);
                BasicDictionary schema = (BasicDictionary)this.run(tableName + ".schema()", 0L);
                BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
                BasicStringVector colDefsName = (BasicStringVector)colDefs.getColumn("name");
                BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
                int cols = colDefs.rows();
                int rows = ((BasicInt)this.run("rows(" + tableName + ")", 0L)).getInt();
                HashMap<Integer, Entity.DATA_TYPE> types2Index = new HashMap<Integer, Entity.DATA_TYPE>();
                HashMap<Integer, String> name2Index = new HashMap<Integer, String>();
                for (int i = 0; i < cols; ++i) {
                    types2Index.put(types2Index.size(), Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
                    name2Index.put(name2Index.size(), colDefsName.getString(i));
                }
                return new BasicTableSchema(types2Index, name2Index, rows, cols, tableName, DBConnection.this);
            }
            StringBuilder body = new StringBuilder();
            int argCount = args.size();
            if (scriptType == "script") {
                body.append("script\n" + script);
            } else {
                body.append(scriptType + "\n" + script);
                body.append("\n" + String.valueOf(argCount));
                body.append("\n");
                body.append(this.remoteLittleEndian_ ? "1" : "0");
            }
            try {
                this.out_.writeBytes((listener != null ? "API2 " : "API ") + this.sessionID_ + " ");
                this.out_.writeBytes(String.valueOf(AbstractExtendedDataOutputStream.getUTFlength(body.toString(), 0, 0)));
                int flag = this.generateRequestFlag(clearMemory);
                HashMap<Property, Object> properties = new HashMap<Property, Object>();
                properties.put(Property.flag, flag);
                properties.put(Property.cancel, 1);
                properties.put(Property.priority, priority);
                properties.put(Property.parallelism, parallelism);
                if (fetchSize > 0) {
                    properties.put(Property.fetchSize, fetchSize);
                }
                if (DBConnection.this.enableHighAvailability_ && DBConnection.this.runClientId_ != null && seqNum != 0L) {
                    properties.put(Property.clientId, DBConnection.this.runClientId_);
                    properties.put(Property.seqNo, seqNum);
                }
                int lastNotNullValue = -1;
                StringBuilder sbProp = new StringBuilder(" / ");
                for (Property key : Property.values()) {
                    Object value = properties.get((Object)key);
                    if (value != null) {
                        sbProp.append(value);
                        lastNotNullValue = sbProp.length();
                    }
                    sbProp.append("_");
                }
                sbProp.delete(lastNotNullValue, sbProp.length());
                sbProp.append('\n');
                this.out_.writeBytes(sbProp.toString());
                this.out_.writeBytes(body.toString());
                if (argCount > 0) {
                    for (int i = 0; i < args.size(); ++i) {
                        if (this.compress_ && args.get(i).isTable()) {
                            args.get(i).writeCompressed(this.out_);
                            continue;
                        }
                        args.get(i).write(this.out_);
                    }
                    this.out_.flush();
                } else {
                    this.out_.flush();
                }
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Couldn't send script/function to the remote host because the connection has been closed");
            }
            if (this.asynTask_) {
                return null;
            }
            String header = null;
            try {
                header = this.in_.readLine();
                while (header.equals("MSG")) {
                    String msg = this.in_.readString();
                    if (listener != null) {
                        listener.progress(msg);
                    }
                    header = this.in_.readLine();
                }
            }
            catch (IOException ex) {
                if (ex instanceof SocketTimeoutException) {
                    throw ex;
                }
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            String[] headers = header.split(" ");
            if (headers.length != 3) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Received invalid header");
            }
            int numObject = Integer.parseInt(headers[1]);
            try {
                header = this.in_.readLine();
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read response header from the socket with IO error " + ex.getMessage());
            }
            if (!header.equals("OK")) {
                if (scriptType == "script") {
                    throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: " + header + ". script: " + script + "");
                }
                throw new IOException(this.hostName_ + ":" + this.port_ + " Server response: " + header + ". " + scriptType + ": " + script + "");
            }
            if (numObject == 0) {
                return new Void();
            }
            try {
                boolean extended;
                short flag = this.in_.readShort();
                int form = flag >> 8;
                int type = flag & 0xFF;
                boolean bl = extended = type >= 128;
                if (type >= 128) {
                    type -= 128;
                }
                if (form < 0 || form > MAX_FORM_VALUE) {
                    throw new IOException("Invalid form value: " + form);
                }
                if (type < 0 || type > MAX_TYPE_VALUE) {
                    throw new IOException("Invalid type value: " + type);
                }
                Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
                Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(type);
                if (fetchSize > 0 && df == Entity.DATA_FORM.DF_VECTOR && dt == Entity.DATA_TYPE.DT_ANY) {
                    return new EntityBlockReader(this.in_);
                }
                EntityFactory factory = BasicEntityFactory.instance();
                return factory.createEntity(df, dt, this.in_, extended);
            }
            catch (IOException ex) {
                this.isConnected_ = false;
                this.socket_ = null;
                throw new IOException("Failed to read object flag from the socket with IO error type " + ex.getMessage());
            }
        }

        public void upload(String name, Entity obj, long seqNum) throws IOException {
            if (!Utils.isVariableCandidate(name)) {
                throw new RuntimeException(name + " is not a qualified variable name.");
            }
            ArrayList<Entity> args = new ArrayList<Entity>();
            args.add(obj);
            this.run(name, "variable", args, seqNum);
        }

        public void upload(List<String> names, List<Entity> objs, long seqNum) throws IOException {
            if (names.size() != objs.size()) {
                throw new RuntimeException("the size of variable names doesn't match the size of objects.");
            }
            if (names.isEmpty()) {
                return;
            }
            StringBuilder varNames = new StringBuilder();
            for (int i = 0; i < names.size(); ++i) {
                if (!Utils.isVariableCandidate(names.get(i))) {
                    throw new RuntimeException(names.get(i) + " is not a qualified variable name.");
                }
                if (i > 0) {
                    varNames.append(",");
                }
                varNames.append(names.get(i));
            }
            this.run(varNames.toString(), "variable", objs, seqNum);
        }

        public void close() {
            this.lock_.lock();
            try {
                if (this.socket_ != null) {
                    this.socket_.close();
                    this.socket_ = null;
                    this.sessionID_ = "";
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock_.unlock();
            }
            this.isConnected_ = false;
        }

        public boolean isConnected() {
            return this.isConnected_;
        }

        public void getNode(Node node) {
            node.hostName = this.hostName_;
            node.port = this.port_;
        }

        public boolean getRemoteLittleEndian() {
            return this.remoteLittleEndian_;
        }

        public ExtendedDataInput getDataInputStream() {
            return this.in_;
        }

        static /* synthetic */ Entity access$3300(DBConnectionImpl x0, String x1, ProgressListener x2, List x3, int x4, int x5, int x6, boolean x7, long x8) throws IOException {
            return x0.run(x1, x2, x3, x4, x5, x6, x7, x8);
        }
    }

    static enum Property {
        flag,
        cancel,
        priority,
        parallelism,
        jobId,
        fetchSize,
        offset,
        clientId,
        seqNo;

    }

    public static class ConnectConfig {
        private String hostName;
        private int port;
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private String userId = "";
        private String password = "";
        private String initialScript = null;
        private boolean enableHighAvailability;
        private String[] highAvailabilitySites = null;
        private boolean reconnect;
        private boolean enableLoadBalance;
        private int tryReconnectNums = -1;
        private boolean ifUserSetEnableLoadBalance;

        private ConnectConfig() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getPassword() {
            return this.password;
        }

        public String getInitialScript() {
            return this.initialScript;
        }

        public boolean getEnableHighAvailability() {
            return this.enableHighAvailability;
        }

        public String[] getHighAvailabilitySites() {
            return this.highAvailabilitySites;
        }

        public boolean getReconnect() {
            return this.reconnect;
        }

        public boolean getEnableLoadBalance() {
            return this.enableLoadBalance;
        }

        public int getTryReconnectNums() {
            return this.tryReconnectNums;
        }

        static /* synthetic */ String[] access$1002(ConnectConfig x0, String[] x1) {
            x0.highAvailabilitySites = x1;
            return x1;
        }

        public static class Builder {
            private final ConnectConfig config = new ConnectConfig();

            private Builder() {
            }

            public Builder hostName(String hostName) {
                this.config.hostName = hostName;
                return this;
            }

            public Builder port(int port) {
                this.config.port = port;
                return this;
            }

            public Builder connectTimeout(int connectTimeout) {
                this.config.connectTimeout = connectTimeout;
                return this;
            }

            public Builder readTimeout(int readTimeout) {
                this.config.readTimeout = readTimeout;
                return this;
            }

            public Builder userId(String userId) {
                this.config.userId = userId;
                return this;
            }

            public Builder password(String password) {
                this.config.password = password;
                return this;
            }

            public Builder initialScript(String initialScript) {
                this.config.initialScript = initialScript;
                return this;
            }

            public Builder enableHighAvailability(boolean enableHighAvailability) {
                this.config.enableHighAvailability = enableHighAvailability;
                return this;
            }

            public Builder highAvailabilitySites(String[] highAvailabilitySites) {
                ConnectConfig.access$1002(this.config, highAvailabilitySites);
                return this;
            }

            public Builder reconnect(boolean reconnect) {
                this.config.reconnect = reconnect;
                return this;
            }

            public Builder enableLoadBalance(boolean enableLoadBalance) {
                this.config.enableLoadBalance = enableLoadBalance;
                this.config.ifUserSetEnableLoadBalance = true;
                return this;
            }

            public Builder tryReconnectNums(int tryReconnectNums) {
                this.config.tryReconnectNums = tryReconnectNums;
                return this;
            }

            public ConnectConfig build() {
                this.validateConfig();
                return this.config;
            }

            private void validateConfig() {
                if (Utils.isEmpty(this.config.hostName)) {
                    throw new IllegalArgumentException("The param 'hostName' cannot be null or empty.");
                }
                if (this.config.port <= 0 || this.config.port > 65535) {
                    throw new IllegalArgumentException("The param 'port' cannot less than or equal to 0, and also cannot greater than 65535.");
                }
                if (this.config.connectTimeout < 0 || this.config.readTimeout < 0) {
                    throw new IllegalArgumentException("The param connectTimeout or readTimeout cannot less than zero.");
                }
                if (this.config.enableHighAvailability && !this.config.ifUserSetEnableLoadBalance) {
                    this.config.enableLoadBalance = true;
                }
            }
        }
    }

    private static class Node {
        private String hostName;
        private int port;
        private double load = -1.0;

        public Node() {
            this.load = -1.0;
        }

        public Node(String hostName, int port, double load) {
            this.hostName = hostName;
            this.port = port;
            this.load = load;
        }

        public Node(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
            this.load = -1.0;
        }

        public Node(String ipPort) {
            String[] v = ipPort.split(":");
            if (v.length < 2) {
                throw new RuntimeException("The ipPort '" + ipPort + "' is invalid.");
            }
            this.hostName = v[0];
            this.port = Integer.parseInt(v[1]);
            this.load = -1.0;
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node node = (Node)o;
                if (node.hostName == null || this.hostName == null) {
                    return false;
                }
                int diff = this.hostName.compareTo(node.hostName);
                if (diff != 0) {
                    return false;
                }
                return this.port == node.port;
            }
            return false;
        }
    }

    private static enum ExceptionType {
        ET_IGNORE(0),
        ET_UNKNOW(1),
        ET_NEWLEADER(2),
        ET_NODENOTAVAIL(3),
        ET_NOINITIALIZED(4),
        ET_NOTLEADER(5),
        ET_READTIMEDOUT(6),
        ET_NORESPONSEHEADER(7),
        ET_LOGINREQUIRED(8);

        public int value;

        private ExceptionType(int value) {
            this.value = value;
        }
    }
}

