/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.List;

public class BasicDateHourVector
extends BasicIntVector {
    public BasicDateHourVector(int size) {
        super(size);
    }

    public BasicDateHourVector(List<Integer> list) {
        super(list);
    }

    public BasicDateHourVector(int[] array) {
        super(array);
    }

    protected BasicDateHourVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicDateHourVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicDateHourVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATEHOUR;
    }

    @Override
    public Entity get(int index) {
        return new BasicDateHour(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicDateHourVector(this.getSubArray(indices), false);
    }

    public LocalDateTime getDateHour(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseDateHour(this.getInt(index));
    }

    public void setDateHour(int index, LocalDateTime dt) {
        this.setInt(index, Utils.countHours(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDateHour.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDateHourVector v = (BasicDateHourVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicDateHourVector(newValue);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (int val : data) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicDateHourVector)value).getdataArray());
    }
}

