/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicString;
import com.xxdb.data.CHART_PARAMETER_TYPE;
import com.xxdb.data.Chart;
import com.xxdb.data.Entity;
import com.xxdb.data.Matrix;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;

public class BasicChart
extends BasicDictionary
implements Chart {
    private static BasicString KEY_CHARTTYPE = new BasicString("chartType");
    private static BasicString KEY_DATA = new BasicString("data");
    private static BasicString KEY_TITLE = new BasicString("title");
    private static BasicString KEY_PARAMETER = new BasicString("extras");

    public BasicChart(ExtendedDataInput in) throws IOException {
        super(Entity.DATA_TYPE.DT_ANY, in);
    }

    public BasicChart(int capacity) {
        super(Entity.DATA_TYPE.DT_STRING, Entity.DATA_TYPE.DT_ANY, capacity);
    }

    public BasicChart() {
        this(0);
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_CHART;
    }

    @Override
    @JsonIgnore
    public Chart.CHART_TYPE getChartType() throws Exception {
        Entity chartType = this.get(KEY_CHARTTYPE);
        if (chartType == null || !chartType.isScalar()) {
            throw new RuntimeException("Invalid chart object. Chart type is not defined.");
        }
        return Chart.CHART_TYPE.values()[((Scalar)chartType).getNumber().intValue()];
    }

    @Override
    @JsonIgnore
    public Matrix getData() {
        Entity data = this.get(KEY_DATA);
        if (data == null || !data.isMatrix()) {
            throw new RuntimeException("Invalid chart object. Chart data is not set.");
        }
        return (Matrix)data;
    }

    @Override
    public String getTitle() {
        Entity title = this.get(KEY_TITLE);
        if (title == null || !title.isScalar() && !title.isVector()) {
            return "";
        }
        if (title.isScalar()) {
            return title.getString();
        }
        return ((Vector)title).get(0).getString();
    }

    @Override
    public String getXAxisName() {
        Entity title = this.get(KEY_TITLE);
        if (title == null || !title.isVector() || title.rows() < 2) {
            return "";
        }
        return ((Vector)title).get(1).getString();
    }

    @Override
    public String getYAxisName() {
        Entity title = this.get(KEY_TITLE);
        if (title == null || !title.isVector() || title.rows() < 3) {
            return "";
        }
        return ((Vector)title).get(2).getString();
    }

    @Override
    public BasicDictionary getExtraParameters() {
        Entity param = this.get(KEY_PARAMETER);
        if (param != null) {
            return (BasicDictionary)param;
        }
        return null;
    }

    @Override
    public Entity getExtraParameter(CHART_PARAMETER_TYPE key) {
        Entity param = this.get(KEY_PARAMETER);
        if (param != null) {
            return ((BasicDictionary)param).get(new BasicString(key.name()));
        }
        return null;
    }
}

