/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class BasicBooleanVector
extends AbstractVector {
    private byte[] values;
    private int size;
    private int capaticy;

    public BasicBooleanVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicBooleanVector(List<Byte> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : (byte)-128;
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicBooleanVector(byte[] array) {
        this(array, true);
    }

    static byte[] convert(boolean[] b) {
        byte[] ret = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            ret[i] = (byte)(b[i] ? 1 : 0);
        }
        return ret;
    }

    public BasicBooleanVector(boolean[] b) {
        this(BasicBooleanVector.convert(b), true);
    }

    protected BasicBooleanVector(byte[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (byte[])array.clone() : array;
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicBooleanVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new byte[size];
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicBooleanVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        this.values = new byte[rows];
        for (int off = 0; off < rows; off += len) {
            len = Math.min(4096, rows - off);
            in.readFully(this.values, off, len);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        in.readFully(this.values, start, count);
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeByte(this.values[start + i]);
        }
    }

    @Override
    public Entity get(int index) {
        return new BasicBoolean(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        byte[] sub = new byte[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicBooleanVector(sub, false);
    }

    public boolean getBoolean(int index) {
        return this.values[index] != 0;
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index] = ((Scalar)value).isNull() ? -128 : ((Scalar)value).getNumber().byteValue();
    }

    public void setBoolean(int index, boolean value) {
        this.values[index] = value ? (byte)1 : 0;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicBooleanVector v = (BasicBooleanVector)vector;
        int newSize = this.rows() + v.rows();
        byte[] newValue = new byte[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicBooleanVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -128;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -128;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LOGICAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BOOL;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicBoolean.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.write(data);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicBooleanVector.asof not supported.");
    }

    @Override
    public int getUnitLength() {
        return 1;
    }

    public void add(byte value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(byte[] valueList) {
        int requiredCapacity = this.size + valueList.length;
        this.checkCapacity(requiredCapacity);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().byteValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicBooleanVector)value).getdataArray());
    }

    @Override
    public void checkCapacity(int requiredCapacity) {
        if (requiredCapacity > this.values.length) {
            int newCapacity = Math.max((int)((double)this.values.length * 1.5), requiredCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
            this.capaticy = newCapacity;
        }
    }

    public byte[] getdataArray() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        byte[] data = new byte[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (byte val : data) {
            buffer.put(val);
        }
        return buffer;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.put(this.values[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement;
    }

    public byte[] getValues() {
        return this.values;
    }
}

