/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicComplex;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicComplexMatrix
extends AbstractMatrix {
    private Double2[] values;

    public BasicComplexMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new Double2[rows * columns];
    }

    public BasicComplexMatrix(int rows, int columns, List<Double2[]> listOfArrays) throws Exception {
        super(rows, columns);
        this.values = new Double2[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            Double2[] array = listOfArrays.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicComplexMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setComplex(int row, int column, double real, double image) {
        this.values[this.getIndex((int)row, (int)column)] = new Double2(real, image);
    }

    public Double2 getDouble(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)].isNull();
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex(row, column)].setNull();
    }

    @Override
    public Scalar get(int row, int column) {
        int index = this.getIndex(row, column);
        return new BasicComplex(this.values[index].x, this.values[index].y);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_COMPLEX;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicComplex.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        ByteOrder bo;
        int size = rows * columns;
        this.values = new Double2[size];
        long totalBytes = (long)size * 16L;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = (int)(off / 16L);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = new Double2(byteBuffer.getDouble(i * 16), byteBuffer.getDouble(i * 16 + 8));
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (Double2 value : this.values) {
            out.writeDouble2(value);
        }
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

