/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;
import java.util.Objects;

public class BasicPoint
extends AbstractScalar {
    protected Double2 value;

    public BasicPoint(double real, double image) {
        this.value = new Double2(real, image);
    }

    public BasicPoint(ExtendedDataInput in) throws IOException {
        this.value = in.readDouble2();
    }

    public Double2 getDouble2() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public void setNull() {
        this.value.setNull();
    }

    public double getX() {
        return this.value.x;
    }

    public double getY() {
        return this.value.y;
    }

    @Override
    @JsonIgnore
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_POINT;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "(,)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.value.x);
        sb.append(", ");
        sb.append(this.value.y);
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (Objects.isNull(o)) {
            return false;
        }
        if (!(o instanceof BasicPoint)) {
            return false;
        }
        return this.value.equals(((BasicPoint)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return this.value.hashBucket(buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDouble2(this.value);
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

