/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final int SHA256_DIGEST_LENGTH = 32;

    public static String base64Encode(byte[] text, boolean noNewLines) {
        Base64.Encoder encoder = noNewLines ? Base64.getEncoder().withoutPadding() : Base64.getEncoder();
        return encoder.encodeToString(text);
    }

    public static byte[] base64Decode(String input, boolean noNewLines) {
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        Base64.Decoder decoder = noNewLines ? Base64.getDecoder() : Base64.getMimeDecoder();
        return decoder.decode(input);
    }

    public static String generateNonce(int length) {
        byte[] buffer = new byte[length];
        secureRandom.nextBytes(buffer);
        return Base64.getEncoder().encodeToString(buffer);
    }

    public static byte[] pbkdf2HmacSha256(String password, byte[] salt, int iterCount) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterCount, 256);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] saltedPassword = factory.generateSecret(spec).getEncoded();
            spec.clearPassword();
            return saltedPassword;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Failed to compute PBKDF2-HMAC-SHA256: " + e.getMessage(), e);
        }
    }

    public static byte[] computeClientKey(byte[] saltedPassword) {
        if (saltedPassword == null || saltedPassword.length != 32) {
            throw new IllegalArgumentException("Invalid salted password");
        }
        byte[] clientKeyData = "Client Key".getBytes();
        return CryptoUtils.hmacSha256(saltedPassword, clientKeyData);
    }

    public static byte[] computeStoredKey(byte[] clientKey) {
        if (clientKey == null || clientKey.length != 32) {
            throw new IllegalArgumentException("Invalid client key");
        }
        return CryptoUtils.sha256(clientKey);
    }

    public static byte[] computeClientSignature(byte[] storedKey, String authMessage) {
        if (storedKey == null || storedKey.length != 32) {
            throw new IllegalArgumentException("Invalid stored key");
        }
        if (authMessage == null) {
            throw new IllegalArgumentException("Auth message cannot be null");
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(storedKey, "HmacSHA256");
            hmac.init(secretKey);
            return hmac.doFinal(authMessage.getBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute client signature: " + e.getMessage(), e);
        }
    }

    public static byte[] computeProof(byte[] clientKey, byte[] clientSignature) {
        if (clientKey == null || clientSignature == null || clientKey.length != clientSignature.length) {
            throw new IllegalArgumentException("Invalid input arrays");
        }
        byte[] proof = new byte[clientKey.length];
        for (int i = 0; i < clientKey.length; ++i) {
            proof[i] = (byte)(clientKey[i] ^ clientSignature[i]);
        }
        return proof;
    }

    public static byte[] computeServerKey(byte[] saltedPassword) {
        if (saltedPassword == null || saltedPassword.length != 32) {
            throw new IllegalArgumentException("Invalid salted password");
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(saltedPassword, "HmacSHA256");
            hmac.init(secretKey);
            return hmac.doFinal("Server Key".getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute server key: " + e.getMessage(), e);
        }
    }

    public static byte[] computeServerSignature(byte[] serverKey, String authMessage) {
        if (serverKey == null || serverKey.length != 32) {
            throw new IllegalArgumentException("Invalid server key");
        }
        if (authMessage == null) {
            throw new IllegalArgumentException("Auth message cannot be null");
        }
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(serverKey, "HmacSHA256");
            hmac.init(secretKey);
            return hmac.doFinal(authMessage.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute server signature: " + e.getMessage(), e);
        }
    }

    public static byte[] hmacSha256(byte[] key, byte[] data) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKey);
            return hmac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute HMAC-SHA256: " + e.getMessage(), e);
        }
    }

    public static byte[] sha256(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }
}

