/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicInt128Vector
extends AbstractVector {
    protected Long2[] values;
    protected int size;
    protected int capaticy;

    public BasicInt128Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicInt128Vector(List<Long2> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new Long2[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : new Long2(0L, 0L);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicInt128Vector(Long2[] array) {
        this(array, true);
    }

    protected BasicInt128Vector(Long2[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (Long2[])array.clone() : array;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            this.values[i] = new Long2(0L, 0L);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new Long2[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new Long2(0L, 0L);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        this.values = new Long2[rows];
        long totalBytes = (long)rows * 16L;
        boolean littleEndian = in.isLittleEndian();
        ByteOrder bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            int i;
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 16L);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            if (littleEndian) {
                for (i = 0; i < end; ++i) {
                    long low = byteBuffer.getLong(i * 16);
                    long high = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
                continue;
            }
            for (i = 0; i < end; ++i) {
                long high = byteBuffer.getLong(i * 16);
                long low = byteBuffer.getLong(i * 16 + 8);
                this.values[i + start] = new Long2(high, low);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 16L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        boolean littleEndian = in.isLittleEndian();
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int i;
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            if (littleEndian) {
                for (i = 0; i < end; ++i) {
                    long low = byteBuffer.getLong(i * 16);
                    long high = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
            } else {
                for (i = 0; i < end; ++i) {
                    long high = byteBuffer.getLong(i * 16);
                    long low = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeLong2(this.values[start + i]);
        }
    }

    @Override
    public Entity get(int index) {
        return new BasicInt128(this.values[index].high, this.values[index].low);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        Long2[] sub = new Long2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicInt128Vector(sub, false);
    }

    protected Long2[] getSubArray(int[] indices) {
        int length = indices.length;
        Long2[] sub = new Long2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index].high = ((BasicInt128)value).getMostSignicantBits();
        this.values[index].low = ((BasicInt128)value).getLeastSignicantBits();
    }

    public void setInt128(int index, long highValue, long lowValue) {
        this.values[index].high = highValue;
        this.values[index].low = lowValue;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.values[index].hashBucket(buckets);
    }

    @Override
    public int getUnitLength() {
        return 16;
    }

    public void add(Long2 value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(Long2[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(new Long2(((BasicInt128)value).getMostSignicantBits(), ((BasicInt128)value).getLeastSignicantBits()));
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicInt128Vector)value).getdataArray());
    }

    @Override
    public void checkCapacity(int requiredCapacity) {
        throw new RuntimeException("BasicInt128Vector not support checkCapacity.");
    }

    public Long2[] getdataArray() {
        Long2[] data = new Long2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicInt128Vector v = (BasicInt128Vector)vector;
        int newSize = this.rows() + v.rows();
        Long2[] newValue = new Long2[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicInt128Vector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index].isNull();
    }

    @Override
    public void setNull(int index) {
        this.values[index].setNull();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT128;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt128.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        Long2[] data = new Long2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeLong2Array(data);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicInt128Vector.asof not supported.");
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        boolean isLittleEndian = buffer.order() == ByteOrder.LITTLE_ENDIAN;
        Long2[] data = new Long2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (Long2 val : data) {
            if (isLittleEndian) {
                buffer.putLong(val.low);
                buffer.putLong(val.high);
                continue;
            }
            buffer.putLong(val.high);
            buffer.putLong(val.low);
        }
        return buffer;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        boolean isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            if (isLittleEndian) {
                out.putLong(this.values[indexStart + i].low);
                out.putLong(this.values[indexStart + i].high);
                continue;
            }
            out.putLong(this.values[indexStart + i].high);
            out.putLong(this.values[indexStart + i].low);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 16;
    }

    public Long2[] getValues() {
        return this.values;
    }

    public String getJsonString() {
        return this.getString();
    }
}

