/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;

public class BasicMinute
extends BasicInt {
    public BasicMinute(LocalTime value) {
        super(Utils.countMinutes(value));
    }

    public BasicMinute(Calendar value) {
        super(Utils.countMinutes(value.get(11), value.get(12)));
    }

    public BasicMinute(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public BasicMinute(int value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MINUTE;
    }

    public LocalTime getMinute() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseMinute(this.getInt());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getMinute();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getMinute().format(DateTimeFormatter.ofPattern("HH:mm'm'"));
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicMinute) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicMinute)o).getInt();
    }
}

