/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client.cep;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.streaming.client.cep.AttributeSerializer;
import java.io.IOException;

public class FastArrayAttributeSerializer
extends AttributeSerializer {
    public FastArrayAttributeSerializer(int unitLen) {
        super(unitLen, Entity.DATA_FORM.DF_VECTOR);
    }

    @Override
    public void serialize(Entity attribute, ExtendedDataOutput out) throws IOException {
        int curCount = attribute.rows();
        if (curCount == 0) {
            out.writeShort(0);
            return;
        }
        int arrayRows = 1;
        int curCountBytes = 1;
        int reserved = 0;
        int maxCount = 255;
        while (curCount > maxCount) {
            curCountBytes = (byte)(curCountBytes * 2);
            maxCount = (int)((1L << 8 * curCountBytes) - 1L);
        }
        out.writeShort(arrayRows);
        out.writeByte(curCountBytes);
        out.writeByte(reserved);
        switch (curCountBytes) {
            case 1: {
                out.writeByte((byte)(curCount & 0xFF));
                break;
            }
            case 2: {
                out.writeShort((short)(curCount & 0xFFFF));
                break;
            }
            default: {
                out.writeInt(curCount);
            }
        }
        ((AbstractVector)attribute).serialize(0, curCount, out);
    }
}

