/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicIotAnyVector
extends AbstractVector {
    private Map<Integer, Entity> subVector;
    private BasicIntVector indexsDataType;
    private BasicIntVector indexs;
    private static final Logger log = LoggerFactory.getLogger(BasicIotAnyVector.class);

    public BasicIotAnyVector(Scalar[] scalars) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (Objects.isNull(scalars) || scalars.length == 0) {
            throw new RuntimeException("The param 'scalars' cannot be null or empty.");
        }
        this.subVector = new HashMap<Integer, Entity>();
        this.indexsDataType = new BasicIntVector(0);
        this.indexs = new BasicIntVector(0);
        try {
            for (Scalar scalar : scalars) {
                int curDataTypeValue = scalar.getDataType().getValue();
                if (Objects.isNull(this.subVector.get(curDataTypeValue))) {
                    Vector curVector = BasicEntityFactory.instance().createVectorWithDefaultValue(scalar.getDataType(), 0, -1);
                    curVector.Append(scalar);
                    this.subVector.put(curDataTypeValue, curVector);
                } else {
                    ((Vector)this.subVector.get(curDataTypeValue)).Append(scalar);
                }
                this.indexsDataType.add(curDataTypeValue);
                this.indexs.add(this.subVector.get(curDataTypeValue).rows() - 1);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    protected BasicIotAnyVector(ExtendedDataInput in) throws IOException {
        super(Entity.DATA_FORM.DF_VECTOR);
        BasicAnyVector anyVector = new BasicAnyVector(in);
        BasicIntVector intVector = (BasicIntVector)anyVector.get(0);
        int indexsLen = ((BasicInt)intVector.get(0)).getInt();
        int subVecNum = ((BasicInt)intVector.get(1)).getInt();
        int[] tmpIntArray = new int[indexsLen];
        System.arraycopy(intVector.getdataArray(), 2, tmpIntArray, 0, indexsLen);
        this.indexs = new BasicIntVector(tmpIntArray);
        tmpIntArray = new int[indexsLen];
        System.arraycopy(intVector.getdataArray(), indexsLen + 2, tmpIntArray, 0, indexsLen);
        this.indexsDataType = new BasicIntVector(tmpIntArray);
        this.subVector = new HashMap<Integer, Entity>();
        for (int i = 1; i <= subVecNum; ++i) {
            Entity.DATA_TYPE dataType = anyVector.get(i).getDataType();
            this.subVector.put(dataType.getValue(), anyVector.get(i));
        }
    }

    @Override
    public Entity get(int index) {
        if (index >= this.rows()) {
            throw new RuntimeException(String.format("index %s out of rows %s.", index, this.rows()));
        }
        BasicInt curDataType = (BasicInt)this.indexsDataType.get(index);
        BasicInt curIndex = (BasicInt)this.indexs.get(index);
        if (curDataType.getInt() == 0) {
            return new Void();
        }
        return ((Vector)this.subVector.get(curDataType.getInt())).get(curIndex.getInt());
    }

    @Override
    public String getString(int index) {
        return this.get(index).getString();
    }

    @Override
    public Vector getSubVector(int[] indices) {
        throw new RuntimeException("BasicIotAnyVector.getSubVector not supported.");
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        throw new RuntimeException("BasicIotAnyVector.set not supported.");
    }

    @Override
    public void set(int index, Object value) {
        throw new RuntimeException("BasicIotAnyVector.set not supported.");
    }

    @Override
    public Vector combine(Vector vector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull(int index) {
        throw new RuntimeException("BasicIotAnyVector.isNull not supported.");
    }

    @Override
    public void setNull(int index) {
        throw new RuntimeException("BasicIotAnyVector.setNull not supported.");
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.MIXED;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_IOTANY;
    }

    @Override
    public int rows() {
        return this.indexs.rows();
    }

    protected int serializeAnyVectorRows() {
        return this.subVector.size() + 1;
    }

    @Override
    @JsonIgnore
    public int getUnitLength() {
        throw new RuntimeException("IotAnyVector.getUnitLength not supported.");
    }

    @Override
    public void add(Object value) {
        throw new RuntimeException("IotAnyVector.add not supported.");
    }

    public void addRange(Object[] valueList) {
        throw new RuntimeException("IotAnyVector.addRange not supported.");
    }

    @Override
    public void Append(Scalar value) {
        throw new RuntimeException("IotAnyVector.Append not supported.");
    }

    @Override
    public void Append(Vector value) {
        throw new RuntimeException("IotAnyVector.Append not supported.");
    }

    @Override
    public void checkCapacity(int requiredCapacity) {
        throw new RuntimeException("BasicIotAnyVector not support checkCapacity.");
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.rows(); ++i) {
            sb.append(this.getString(i)).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Class<?> getElementClass() {
        return Entity.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        throw new RuntimeException("BasicIotAnyVector.serialize not supported.");
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        throw new RuntimeException("BasicIotAnyVector.serialize not supported.");
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] tmpIntArray = new int[this.rows() * 2 + 2];
        tmpIntArray[0] = this.rows();
        tmpIntArray[1] = this.subVector.size();
        System.arraycopy(this.indexs.getdataArray(), 0, tmpIntArray, 2, this.rows());
        System.arraycopy(this.indexsDataType.getdataArray(), 0, tmpIntArray, this.rows() + 2, this.indexsDataType.size);
        BasicIntVector intVector = new BasicIntVector(tmpIntArray);
        Entity[] entities = new Entity[1 + this.subVector.size()];
        entities[0] = intVector;
        int index = 1;
        Iterator<Entity> iterator = this.subVector.values().iterator();
        while (iterator.hasNext()) {
            Entity value;
            entities[index] = value = iterator.next();
            ++index;
        }
        BasicAnyVector anyVector = new BasicAnyVector(entities, false);
        anyVector.writeVectorToOutputStream(out);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicAnyVector.asof not supported.");
    }
}

