/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client.streamingSQL;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicArrayVector;
import com.xxdb.data.BasicByte;
import com.xxdb.data.BasicByteVector;
import com.xxdb.data.BasicDecimal128;
import com.xxdb.data.BasicDecimal128Vector;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.BasicDecimal32Vector;
import com.xxdb.data.BasicDecimal64;
import com.xxdb.data.BasicDecimal64Vector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.streaming.client.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSQLResultUpdater {
    private static final Logger log = LoggerFactory.getLogger(StreamingSQLResultUpdater.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StreamingSQLResult updateStreamingSQLResult(BasicTable result, BasicIntVector deleteLineMap, IMessage msg) throws Exception {
        log.debug("Starting updateStreamingSQLResult");
        log.debug("Table columns: " + result.columns() + ", rows: " + result.rows());
        BasicByteVector typeColumn = new BasicByteVector(0);
        typeColumn.Append((BasicByte)msg.getEntity(0));
        byte msgType = ((BasicByte)msg.getEntity(0)).getByte();
        log.debug("Message type: " + msgType);
        BasicIntVector lineNoColumn = new BasicIntVector(0);
        lineNoColumn.Append((BasicInt)msg.getEntity(1));
        ArrayList<Vector> updateColumns = new ArrayList<Vector>();
        for (int i = 2; i < msg.size(); ++i) {
            if (msg.getEntity(i) instanceof Vector) {
                updateColumns.add((Vector)msg.getEntity(i));
                continue;
            }
            Vector col = msg.getEntity(i) instanceof BasicDecimal32 || msg.getEntity(i) instanceof BasicDecimal64 || msg.getEntity(i) instanceof BasicDecimal128 ? BasicEntityFactory.instance().createVectorWithDefaultValue(msg.getEntity(i).getDataType(), 0, ((Scalar)msg.getEntity(i)).getScale()) : BasicEntityFactory.instance().createVectorWithDefaultValue(msg.getEntity(i).getDataType(), 0, -1);
            col.Append((Scalar)msg.getEntity(i));
            updateColumns.add(col);
        }
        int updateLogSize = lineNoColumn.rows();
        Vector[] updateValues = new Vector[updateColumns.size()];
        DeleteLineMapWrapper wrapper = new DeleteLineMapWrapper(deleteLineMap);
        String err = "";
        int start = 0;
        int offset = 0;
        int length = 0;
        byte prevUpdateType = -1;
        if (lineNoColumn.rows() == 1) {
            BasicIntVector vec = new BasicIntVector(1);
            vec.set(0, lineNoColumn.get(0));
            lineNoColumn = vec;
        }
        while (start < updateLogSize) {
            int i;
            int len = Math.min(updateLogSize - start, 1024);
            byte[] ptype = new byte[len];
            for (i = 0; i < len; ++i) {
                ptype[i] = ((BasicByte)typeColumn.get(start + i)).getByte();
                log.debug("Type at index " + (start + i) + ": " + ptype[i]);
            }
            for (i = 0; i < len; ++i) {
                if (ptype[i] != prevUpdateType) {
                    if (length > 0) {
                        log.debug("Processing operation type: " + prevUpdateType);
                        BasicTable basicTable = result;
                        synchronized (basicTable) {
                            if (prevUpdateType == 0) {
                                StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                                if (result.rows() == 0) {
                                    log.debug("Table is empty, treating kUpdate as kAppend");
                                    boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                                    if (!appended) {
                                        throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                                    }
                                } else {
                                    log.debug("=== PROCESSING kUpdate ===");
                                    log.debug("Table rows: " + result.rows());
                                    ArrayList<String> columnNames = new ArrayList<String>();
                                    for (int j = 0; j < result.columns(); ++j) {
                                        columnNames.add(result.getColumnName(j));
                                    }
                                    BasicIntVector updateLineNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                                    log.debug("Original logical line numbers: " + updateLineNo.getString());
                                    StreamingSQLResultUpdater.updateIndexMapping(updateLineNo, result.rows(), wrapper);
                                    log.debug("After mapping to physical line numbers: " + updateLineNo.getString());
                                    ArrayList<Integer> validIndices = new ArrayList<Integer>();
                                    for (int idx = 0; idx < updateLineNo.rows(); ++idx) {
                                        int physicalLineNo = ((BasicInt)updateLineNo.get(idx)).getInt();
                                        log.debug("Checking physical lineNo " + physicalLineNo + " against table size " + result.rows());
                                        if (physicalLineNo >= 0 && physicalLineNo < result.rows()) {
                                            validIndices.add(idx);
                                            log.debug("  -> Valid physical index: " + physicalLineNo);
                                            continue;
                                        }
                                        log.debug("  -> Invalid physical index: " + physicalLineNo + " (table size: " + result.rows() + ")");
                                        log.debug("Warning: Mapped physical index " + physicalLineNo + " out of range, skipping");
                                    }
                                    log.debug("Valid indices count: " + validIndices.size());
                                    if (!validIndices.isEmpty()) {
                                        log.debug("Calling updateRows with valid physical indices");
                                        BasicIntVector validUpdateLineNo = new BasicIntVector(validIndices.size());
                                        Vector[] validUpdateValues = new Vector[updateValues.length];
                                        for (int colIdx = 0; colIdx < updateValues.length; ++colIdx) {
                                            int[] validIndicesArray = new int[validIndices.size()];
                                            for (int j = 0; j < validIndices.size(); ++j) {
                                                validIndicesArray[j] = (Integer)validIndices.get(j);
                                                if (colIdx != 0) continue;
                                                validUpdateLineNo.set(j, updateLineNo.get((Integer)validIndices.get(j)));
                                            }
                                            Vector tableColumn = result.getColumn(colIdx);
                                            if (tableColumn instanceof BasicArrayVector) {
                                                log.debug("Column " + colIdx + " is BasicArrayVector, using original vector");
                                                validUpdateValues[colIdx] = updateValues[colIdx];
                                                continue;
                                            }
                                            log.debug("Column " + colIdx + " is not BasicArrayVector, using getSubVector");
                                            validUpdateValues[colIdx] = ((AbstractVector)updateValues[colIdx]).getSubVector(validIndicesArray);
                                        }
                                        boolean updated = StreamingSQLResultUpdater.updateRows(result, validUpdateValues, validUpdateLineNo, columnNames);
                                        if (!updated) {
                                            throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                                        }
                                    } else {
                                        log.debug("No valid physical indices found after mapping, updateRows not called!");
                                    }
                                    log.debug("=== END PROCESSING kUpdate ===");
                                }
                            } else if (prevUpdateType == 1) {
                                StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                                log.debug("Calling appendColumns for kAppend");
                                boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                                if (!appended) {
                                    throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                                }
                            } else if (prevUpdateType == 2) {
                                BasicIntVector removeLineNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                                StreamingSQLResultUpdater.removeIndexMapping(removeLineNo, result.rows(), wrapper);
                                int[] originalArray = removeLineNo.getdataArray();
                                int[] sortedArray = (int[])originalArray.clone();
                                Arrays.sort(sortedArray);
                                removeLineNo = new BasicIntVector(sortedArray);
                                if (result.rows() > 0) {
                                    result = StreamingSQLResultUpdater.removeRows(result, removeLineNo);
                                }
                            } else if (prevUpdateType == 3) {
                                log.debug("Process kInsert type messages");
                                BasicIntVector insertNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                                int prevSize = result.rows();
                                log.debug("msg content: type=" + prevUpdateType + ", lineNo=" + insertNo.getString() + ", cols=" + (msg.size() - 2));
                                if (insertNo.rows() == 1) {
                                    int[] mapArray;
                                    Vector[] newColumns = new Vector[msg.size() - 2];
                                    for (int j = 2; j < msg.size(); ++j) {
                                        if (msg.getEntity(j) instanceof Vector) {
                                            newColumns[j - 2] = (Vector)msg.getEntity(j);
                                            continue;
                                        }
                                        Scalar sourceValue = (Scalar)msg.getEntity(j);
                                        Entity.DATA_TYPE dataType = sourceValue.getDataType();
                                        Vector newVector = msg.getEntity(j) instanceof BasicDecimal32 || msg.getEntity(j) instanceof BasicDecimal64 || msg.getEntity(j) instanceof BasicDecimal128 ? BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 1, ((Scalar)msg.getEntity(j)).getScale()) : BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 1, -1);
                                        newVector.set(0, sourceValue);
                                        newColumns[j - 2] = newVector;
                                    }
                                    boolean appended = StreamingSQLResultUpdater.appendColumns(result, newColumns);
                                    if (!appended) {
                                        throw new RuntimeException("updateStreamingSQLResult failed when appending new data");
                                    }
                                    log.debug("Successfully added new row, current table row count: " + result.rows());
                                    int logicalInsertPos = ((BasicInt)insertNo.get(0)).getInt();
                                    log.debug("logical insertion position: " + logicalInsertPos);
                                    int physicalInsertPos = logicalInsertPos;
                                    int lineMapSize = wrapper.map != null ? wrapper.map.rows() : 0;
                                    int[] nArray = mapArray = wrapper.map != null ? wrapper.map.getdataArray() : new int[]{};
                                    if (lineMapSize > 0) {
                                        int mapPos = StreamingSQLResultUpdater.findLowerBoundCount(mapArray, lineMapSize, logicalInsertPos);
                                        physicalInsertPos = logicalInsertPos - mapPos;
                                        int j = mapPos;
                                        while (j < lineMapSize) {
                                            int n = j++;
                                            mapArray[n] = mapArray[n] + 1;
                                        }
                                        wrapper.map = new BasicIntVector(mapArray);
                                        log.debug("After considering deleteLineMap, the physical insertion position: " + physicalInsertPos + ", mapPos: " + mapPos);
                                    }
                                    if (physicalInsertPos > prevSize) {
                                        physicalInsertPos = prevSize;
                                    } else if (physicalInsertPos < 0) {
                                        physicalInsertPos = 0;
                                    }
                                    log.debug("Final physical insertion position.: " + physicalInsertPos);
                                    if (physicalInsertPos < prevSize) {
                                        int lastRowIndex;
                                        BasicIntVector sortIndex = new BasicIntVector(result.rows());
                                        int[] sortArray = sortIndex.getdataArray();
                                        for (int j = 0; j < result.rows(); ++j) {
                                            sortArray[j] = j;
                                        }
                                        for (int j = lastRowIndex = prevSize; j > physicalInsertPos; --j) {
                                            sortArray[j] = sortArray[j - 1];
                                        }
                                        sortArray[physicalInsertPos] = lastRowIndex;
                                        ArrayList<Vector> newCols = new ArrayList<Vector>();
                                        for (int col = 0; col < result.columns(); ++col) {
                                            newCols.add(result.getColumn(col).getSubVector(sortArray));
                                        }
                                        result = new BasicTable(StreamingSQLResultUpdater.getColumnNames(result), newCols);
                                        log.debug("Completed single-row insertion reordering");
                                    }
                                } else {
                                    StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                                    boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                                    if (!appended) {
                                        throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                                    }
                                    log.debug("Successfully added new row, current table row count: " + result.rows());
                                    BasicIntVector sortIndex = StreamingSQLResultUpdater.insertIndexMapping(prevSize, insertNo, wrapper);
                                    ArrayList<Vector> newCols = new ArrayList<Vector>();
                                    for (int col = 0; col < result.columns(); ++col) {
                                        newCols.add(result.getColumn(col).getSubVector(sortIndex.getdataArray()));
                                    }
                                    List<String> columnNames = StreamingSQLResultUpdater.getColumnNames(result);
                                    result = new BasicTable(columnNames, newCols);
                                    log.debug("After reordering, the table has " + result.rows() + " rows");
                                }
                                log.debug("Processing completed, current table row count: " + result.rows());
                            }
                        }
                    }
                    offset = start + i;
                    length = 1;
                    prevUpdateType = ptype[i];
                    continue;
                }
                ++length;
            }
            start += len;
        }
        if (length > 0) {
            log.debug("Processing final operation type: " + prevUpdateType);
            BasicTable basicTable = result;
            synchronized (basicTable) {
                if (prevUpdateType == 0) {
                    StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                    if (result.rows() == 0) {
                        log.debug("Table is empty, treating kUpdate as kAppend");
                        boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                        if (!appended) {
                            throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                        }
                    } else {
                        log.debug("=== PROCESSING kUpdate ===");
                        log.debug("Table rows: " + result.rows());
                        ArrayList<String> columnNames = new ArrayList<String>();
                        for (int j = 0; j < result.columns(); ++j) {
                            columnNames.add(result.getColumnName(j));
                        }
                        BasicIntVector updateLineNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                        log.debug("Original logical line numbers: " + updateLineNo.getString());
                        StreamingSQLResultUpdater.updateIndexMapping(updateLineNo, result.rows(), wrapper);
                        log.debug("After mapping to physical line numbers: " + updateLineNo.getString());
                        ArrayList<Integer> validIndices = new ArrayList<Integer>();
                        for (int idx = 0; idx < updateLineNo.rows(); ++idx) {
                            int physicalLineNo = ((BasicInt)updateLineNo.get(idx)).getInt();
                            log.debug("Checking physical lineNo " + physicalLineNo + " against table size " + result.rows());
                            if (physicalLineNo >= 0 && physicalLineNo < result.rows()) {
                                validIndices.add(idx);
                                log.debug("  -> Valid physical index: " + physicalLineNo);
                                continue;
                            }
                            log.debug("  -> Invalid physical index: " + physicalLineNo + " (table size: " + result.rows() + ")");
                            log.debug("Warning: Mapped physical index " + physicalLineNo + " out of range, skipping");
                        }
                        log.debug("Valid indices count: " + validIndices.size());
                        if (!validIndices.isEmpty()) {
                            log.debug("Calling updateRows with valid physical indices");
                            BasicIntVector validUpdateLineNo = new BasicIntVector(validIndices.size());
                            Vector[] validUpdateValues = new Vector[updateValues.length];
                            for (int colIdx = 0; colIdx < updateValues.length; ++colIdx) {
                                int[] validIndicesArray = new int[validIndices.size()];
                                for (int j = 0; j < validIndices.size(); ++j) {
                                    validIndicesArray[j] = (Integer)validIndices.get(j);
                                    if (colIdx != 0) continue;
                                    validUpdateLineNo.set(j, updateLineNo.get((Integer)validIndices.get(j)));
                                }
                                Vector tableColumn = result.getColumn(colIdx);
                                if (tableColumn instanceof BasicArrayVector) {
                                    log.debug("Column " + colIdx + " is BasicArrayVector, using original vector");
                                    validUpdateValues[colIdx] = updateValues[colIdx];
                                    continue;
                                }
                                log.debug("Column " + colIdx + " is not BasicArrayVector, using getSubVector");
                                validUpdateValues[colIdx] = ((AbstractVector)updateValues[colIdx]).getSubVector(validIndicesArray);
                            }
                            boolean updated = StreamingSQLResultUpdater.updateRows(result, validUpdateValues, validUpdateLineNo, columnNames);
                            if (!updated) {
                                throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                            }
                        } else {
                            log.debug("No valid physical indices found after mapping, updateRows not called!");
                        }
                        log.debug("=== END PROCESSING kUpdate ===");
                    }
                } else if (prevUpdateType == 1) {
                    StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                    log.debug("Calling appendColumns for final kAppend");
                    boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                    if (!appended) {
                        throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                    }
                } else if (prevUpdateType == 2) {
                    BasicIntVector removeLineNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                    StreamingSQLResultUpdater.removeIndexMapping(removeLineNo, result.rows(), wrapper);
                    int[] originalArray = removeLineNo.getdataArray();
                    int[] sortedArray = (int[])originalArray.clone();
                    Arrays.sort(sortedArray);
                    removeLineNo = new BasicIntVector(sortedArray);
                    if (result.rows() > 0) {
                        result = StreamingSQLResultUpdater.removeRows(result, removeLineNo);
                    }
                } else if (prevUpdateType == 3) {
                    log.debug("Process kInsert type messages");
                    BasicIntVector insertNo = (BasicIntVector)lineNoColumn.getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
                    int prevSize = result.rows();
                    log.debug("msg content: type=" + prevUpdateType + ", lineNo=" + insertNo.getString() + ", cols=" + (msg.size() - 2));
                    if (insertNo.rows() == 1) {
                        int[] mapArray;
                        Vector[] newColumns = new Vector[msg.size() - 2];
                        for (int j = 2; j < msg.size(); ++j) {
                            if (msg.getEntity(j) instanceof Vector) {
                                newColumns[j - 2] = (Vector)msg.getEntity(j);
                                continue;
                            }
                            Scalar sourceValue = (Scalar)msg.getEntity(j);
                            Entity.DATA_TYPE dataType = sourceValue.getDataType();
                            Vector newVector = msg.getEntity(j) instanceof BasicDecimal32 || msg.getEntity(j) instanceof BasicDecimal64 || msg.getEntity(j) instanceof BasicDecimal128 ? BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 1, ((Scalar)msg.getEntity(j)).getScale()) : BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 1, -1);
                            newVector.set(0, sourceValue);
                            newColumns[j - 2] = newVector;
                        }
                        boolean appended = StreamingSQLResultUpdater.appendColumns(result, newColumns);
                        if (!appended) {
                            throw new RuntimeException("updateStreamingSQLResult failed when appending new data");
                        }
                        log.debug("Successfully added new row, current table row count: " + result.rows());
                        int logicalInsertPos = ((BasicInt)insertNo.get(0)).getInt();
                        log.debug("logical insertion position: " + logicalInsertPos);
                        int physicalInsertPos = logicalInsertPos;
                        int lineMapSize = wrapper.map != null ? wrapper.map.rows() : 0;
                        int[] nArray = mapArray = wrapper.map != null ? wrapper.map.getdataArray() : new int[]{};
                        if (lineMapSize > 0) {
                            int mapPos = StreamingSQLResultUpdater.findLowerBoundCount(mapArray, lineMapSize, logicalInsertPos);
                            physicalInsertPos = logicalInsertPos - mapPos;
                            int j = mapPos;
                            while (j < lineMapSize) {
                                int n = j++;
                                mapArray[n] = mapArray[n] + 1;
                            }
                            wrapper.map = new BasicIntVector(mapArray);
                            log.debug("After considering deleteLineMap, the physical insertion position: " + physicalInsertPos + ", mapPos: " + mapPos);
                        }
                        if (physicalInsertPos > prevSize) {
                            physicalInsertPos = prevSize;
                        } else if (physicalInsertPos < 0) {
                            physicalInsertPos = 0;
                        }
                        log.debug("Final physical insertion position.: " + physicalInsertPos);
                        if (physicalInsertPos < prevSize) {
                            int lastRowIndex;
                            BasicIntVector sortIndex = new BasicIntVector(result.rows());
                            int[] sortArray = sortIndex.getdataArray();
                            for (int j = 0; j < result.rows(); ++j) {
                                sortArray[j] = j;
                            }
                            for (int j = lastRowIndex = prevSize; j > physicalInsertPos; --j) {
                                sortArray[j] = sortArray[j - 1];
                            }
                            sortArray[physicalInsertPos] = lastRowIndex;
                            ArrayList<Vector> newCols = new ArrayList<Vector>();
                            for (int col = 0; col < result.columns(); ++col) {
                                newCols.add(result.getColumn(col).getSubVector(sortArray));
                            }
                            result = new BasicTable(StreamingSQLResultUpdater.getColumnNames(result), newCols);
                            log.debug("Completed single-row insertion reordering");
                        }
                    } else {
                        StreamingSQLResultUpdater.getLinesInLog(updateColumns, updateValues, updateLogSize, offset, length);
                        boolean appended = StreamingSQLResultUpdater.appendColumns(result, updateValues);
                        if (!appended) {
                            throw new RuntimeException("updateStreamingSQLResult failed with error: " + err);
                        }
                        log.debug("Successfully added new row, current table row count: " + result.rows());
                        BasicIntVector sortIndex = StreamingSQLResultUpdater.insertIndexMapping(prevSize, insertNo, wrapper);
                        ArrayList<Vector> newCols = new ArrayList<Vector>();
                        for (int col = 0; col < result.columns(); ++col) {
                            newCols.add(result.getColumn(col).getSubVector(sortIndex.getdataArray()));
                        }
                        List<String> columnNames = StreamingSQLResultUpdater.getColumnNames(result);
                        result = new BasicTable(columnNames, newCols);
                        log.debug("After reordering, the table has " + result.rows() + " rows");
                    }
                    log.debug("Processing completed, current table row count: " + result.rows());
                }
            }
        }
        log.debug("Completed updateStreamingSQLResult, table rows: " + result.rows());
        return new StreamingSQLResult(result, wrapper.map);
    }

    private static void getLinesInLog(List<Vector> updateColumns, Vector[] updateValues, int updateLogSize, int offset, int length) {
        for (int i = 0; i < updateColumns.size(); ++i) {
            int j;
            Vector sourceVector = offset == 0 && updateLogSize == length ? updateColumns.get(i) : ((AbstractVector)updateColumns.get(i)).getSubVector(StreamingSQLResultUpdater.createRangeIndices(offset, length));
            Entity.DATA_TYPE dataType = sourceVector.getDataType();
            int scale = -1;
            if (dataType == Entity.DATA_TYPE.DT_DECIMAL32) {
                scale = ((BasicDecimal32Vector)sourceVector).getScale();
            } else if (dataType == Entity.DATA_TYPE.DT_DECIMAL64) {
                scale = ((BasicDecimal64Vector)sourceVector).getScale();
            } else if (dataType == Entity.DATA_TYPE.DT_DECIMAL128) {
                scale = ((BasicDecimal128Vector)sourceVector).getScale();
            }
            Vector newVector = BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, sourceVector.rows(), scale);
            for (j = 0; j < sourceVector.rows(); ++j) {
                try {
                    Scalar value = (Scalar)sourceVector.get(j);
                    newVector.set(j, value);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error copying data: " + e.getMessage());
                }
            }
            updateValues[i] = newVector;
            log.debug("Created new vector of type " + (Object)((Object)dataType) + " with " + newVector.rows() + " rows");
            for (j = 0; j < Math.min(5, newVector.rows()); ++j) {
                log.debug("Element " + j + ": " + newVector.get(j));
            }
        }
    }

    private static int[] createRangeIndices(int start, int length) {
        int[] indices = new int[length];
        for (int i = 0; i < length; ++i) {
            indices[i] = start + i;
        }
        return indices;
    }

    private static List<String> getColumnNames(BasicTable table) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < table.columns(); ++i) {
            names.add(table.getColumnName(i));
        }
        return names;
    }

    private static int findLowerBoundCount(int[] data, int size, int value) {
        int start = 0;
        int count = size - start;
        if (size > 0 && data[size - 1] < value) {
            return size;
        }
        if (size > 0 && data[0] > value) {
            return 0;
        }
        while (count > 0) {
            int step = count / 2;
            int index = start + step;
            if (data[index] < value) {
                start = index + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return start;
    }

    private static int[] insertSortedVec(BasicIntVector vec, int[] data, int size) {
        int start = vec.rows();
        int[] currentArray = vec.getdataArray();
        int[] newArray = Arrays.copyOf(currentArray, start + size);
        for (int i = 0; i < size; ++i) {
            int cur = data[i];
            for (int curIndex = i + start - 1; curIndex >= 0 && newArray[curIndex] > cur; --curIndex) {
                newArray[curIndex + 1] = newArray[curIndex];
            }
            newArray[curIndex + 1] = cur;
        }
        return newArray;
    }

    private static void updateSortedVec(int[] indexArray, int size, int pos) {
        int i = pos;
        while (i < size) {
            int n = i++;
            indexArray[n] = indexArray[n] + 1;
        }
    }

    private static void removeIndexMapping(Vector removeIndex, int prevSize, DeleteLineMapWrapper wrapper) throws Exception {
        int count;
        int[] mapArray;
        int length = removeIndex.rows();
        int lineMapSize = wrapper.map != null ? wrapper.map.rows() : 0;
        ArrayList<Integer> logicalDeleteList = new ArrayList<Integer>(length);
        int[] nArray = mapArray = wrapper.map != null ? wrapper.map.getdataArray() : new int[]{};
        if (prevSize == 0) {
            log.debug("Table is empty, skipping delete operation in removeIndexMapping");
            return;
        }
        for (int start = 0; start < length; start += count) {
            int i;
            count = Math.min(1024, length - start);
            int[] pindex = new int[count];
            for (i = 0; i < count; ++i) {
                pindex[i] = ((BasicInt)removeIndex.get(start + i)).getInt();
            }
            for (i = 0; i < count; ++i) {
                logicalDeleteList.add(pindex[i]);
                if (lineMapSize <= 0) continue;
                int n = i;
                pindex[n] = pindex[n] - StreamingSQLResultUpdater.findLowerBoundCount(mapArray, lineMapSize, pindex[i]);
                if (pindex[i] < prevSize) continue;
                log.debug("Warning: Adjusting deleteLogNo from " + pindex[i] + " to " + (prevSize - 1));
                pindex[i] = prevSize - 1;
            }
            for (i = 0; i < count; ++i) {
                ((BasicIntVector)removeIndex).set(start + i, new BasicInt(pindex[i]));
            }
        }
        int[] deleteArray = new int[logicalDeleteList.size()];
        for (int i = 0; i < logicalDeleteList.size(); ++i) {
            deleteArray[i] = (Integer)logicalDeleteList.get(i);
        }
        int[] newArray = StreamingSQLResultUpdater.insertSortedVec(wrapper.map, deleteArray, deleteArray.length);
        wrapper.map = new BasicIntVector(newArray);
    }

    private static void updateIndexMapping(Vector updateIndex, int prevSize, DeleteLineMapWrapper wrapper) throws Exception {
        int start;
        int[] mapArray;
        int length = updateIndex.rows();
        int lineMapSize = wrapper.map != null ? wrapper.map.rows() : 0;
        int[] nArray = mapArray = wrapper.map != null ? wrapper.map.getdataArray() : new int[]{};
        if (prevSize == 0) {
            log.debug("Table is empty, skipping index validation in updateIndexMapping");
            return;
        }
        if (lineMapSize > 0) {
            int count;
            for (start = 0; start < length; start += count) {
                int i;
                count = Math.min(1024, length - start);
                int[] pindex = new int[count];
                for (i = 0; i < count; ++i) {
                    pindex[i] = ((BasicInt)updateIndex.get(start + i)).getInt();
                }
                for (i = 0; i < count; ++i) {
                    int n = i;
                    pindex[n] = pindex[n] - StreamingSQLResultUpdater.findLowerBoundCount(mapArray, lineMapSize, pindex[i]);
                    if (pindex[i] < prevSize) continue;
                    log.debug("Warning: Adjusting updateLogNo from " + pindex[i] + " to " + (prevSize - 1));
                    pindex[i] = prevSize - 1;
                }
                for (i = 0; i < count; ++i) {
                    ((BasicIntVector)updateIndex).set(start + i, new BasicInt(pindex[i]));
                }
            }
        } else {
            while (start < length) {
                int count = Math.min(1024, length - start);
                for (int i = 0; i < count; ++i) {
                    int value = ((BasicInt)updateIndex.get(start + i)).getInt();
                    if (value < prevSize) continue;
                    log.debug("Warning: Adjusting updateLogNo from " + value + " to " + (prevSize - 1));
                    ((BasicIntVector)updateIndex).set(start + i, new BasicInt(prevSize - 1));
                }
                start += count;
            }
        }
    }

    private static BasicIntVector insertIndexMapping(int prevSize, Vector insertIndex, DeleteLineMapWrapper wrapper) {
        int i;
        int length = insertIndex.rows();
        BasicIntVector sortIndex = new BasicIntVector(prevSize + length);
        int[] psort = sortIndex.getdataArray();
        int[] originalMapArray = wrapper.map != null ? wrapper.map.getdataArray() : new int[]{};
        int[] mapArray = (int[])originalMapArray.clone();
        int lineMapSize = mapArray.length;
        for (i = 0; i < prevSize + length; ++i) {
            psort[i] = i;
        }
        log.debug("insertIndexMapping start: original size=" + prevSize + ", insert index length=" + length);
        if (lineMapSize > 0) {
            log.debug("deleteLineMap size: " + lineMapSize);
        }
        for (i = 0; i < length; ++i) {
            int logicalInsertPos = ((BasicInt)insertIndex.get(i)).getInt();
            int currIndex = i + prevSize;
            int physicalInsertPos = logicalInsertPos;
            if (lineMapSize > 0) {
                int mapPos = StreamingSQLResultUpdater.findLowerBoundCount(mapArray, lineMapSize, logicalInsertPos);
                physicalInsertPos = logicalInsertPos - mapPos;
                int j = mapPos;
                while (j < lineMapSize) {
                    int n = j++;
                    mapArray[n] = mapArray[n] + 1;
                }
                log.debug("Insert " + i + ": logical position=" + logicalInsertPos + ", map position=" + mapPos + ", physical position=" + physicalInsertPos);
            }
            if (physicalInsertPos > prevSize + i) {
                log.debug("Warning: adjusting physical insert position from " + physicalInsertPos + " to " + (prevSize + i));
                physicalInsertPos = prevSize + i;
            } else if (physicalInsertPos < 0) {
                log.debug("Warning: adjusting physical insert position from " + physicalInsertPos + " to 0");
                physicalInsertPos = 0;
            }
            log.debug("Processing insert " + i + ": logical position=" + logicalInsertPos + ", final physical position=" + physicalInsertPos + ", current index=" + currIndex);
            for (int j = currIndex; j > physicalInsertPos; --j) {
                psort[j] = psort[j - 1];
            }
            psort[physicalInsertPos] = currIndex;
        }
        StringBuilder sb = new StringBuilder("Final sort index: [");
        for (int i2 = 0; i2 < Math.min(20, sortIndex.rows()); ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(psort[i2]);
        }
        if (sortIndex.rows() > 20) {
            sb.append(", ...");
        }
        sb.append("]");
        log.debug(sb.toString());
        boolean[] used = new boolean[psort.length];
        boolean isValid = true;
        for (int i3 = 0; i3 < psort.length; ++i3) {
            if (psort[i3] < 0 || psort[i3] >= psort.length) {
                System.err.println("Invalid sort index at position " + i3 + ": " + psort[i3]);
                isValid = false;
                break;
            }
            if (used[psort[i3]]) {
                System.err.println("Duplicate sort index: " + psort[i3]);
                isValid = false;
                break;
            }
            used[psort[i3]] = true;
        }
        if (!isValid) {
            System.err.println("Sort index invalid, resetting to default order");
            for (int j = 0; j < psort.length; ++j) {
                psort[j] = j;
            }
        }
        if (lineMapSize > 0) {
            wrapper.map = new BasicIntVector(mapArray);
            log.debug("Updated deleteLineMap size: " + wrapper.map.rows());
        }
        return sortIndex;
    }

    private static BasicTable removeRows(BasicTable table, BasicIntVector rowIndices) {
        try {
            if (table.rows() == 0 || rowIndices == null || rowIndices.rows() == 0) {
                return table;
            }
            int[] keepIndices = StreamingSQLResultUpdater.createComplementIndices(table.rows(), rowIndices);
            List<String> columnNames = StreamingSQLResultUpdater.getColumnNames(table);
            if (keepIndices.length == 0) {
                ArrayList<Vector> emptyColumns = new ArrayList<Vector>();
                for (int i = 0; i < table.columns(); ++i) {
                    int scale;
                    if (table.getColumn(i).getDataType().getValue() >= Entity.DATA_TYPE.DT_BOOL_ARRAY.getValue()) {
                        scale = -1;
                        if (table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL32_ARRAY || table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL64_ARRAY || table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL128_ARRAY) {
                            scale = ((BasicArrayVector)table.getColumn(i)).getScale();
                        }
                        emptyColumns.add(new BasicArrayVector(table.getColumn(i).getDataType(), 0, scale));
                        continue;
                    }
                    scale = -1;
                    if (table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL32) {
                        scale = ((BasicDecimal32Vector)table.getColumn(i)).getScale();
                    } else if (table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL64) {
                        scale = ((BasicDecimal64Vector)table.getColumn(i)).getScale();
                    } else if (table.getColumn(i).getDataType() == Entity.DATA_TYPE.DT_DECIMAL128) {
                        scale = ((BasicDecimal128Vector)table.getColumn(i)).getScale();
                    }
                    emptyColumns.add(BasicEntityFactory.instance().createVectorWithDefaultValue(table.getColumn(i).getDataType(), 0, scale));
                }
                return new BasicTable(columnNames, emptyColumns);
            }
            ArrayList<Vector> newColumns = new ArrayList<Vector>();
            for (int i = 0; i < table.columns(); ++i) {
                newColumns.add(table.getColumn(i).getSubVector(keepIndices));
            }
            return new BasicTable(columnNames, newColumns);
        }
        catch (Exception e) {
            log.error("Error in removeRows: " + e.getMessage(), (Throwable)e);
            return table;
        }
    }

    private static int[] createComplementIndices(int totalRows, BasicIntVector excludeIndices) {
        boolean[] exclude = new boolean[totalRows];
        for (int i = 0; i < excludeIndices.rows(); ++i) {
            int idx = ((BasicInt)excludeIndices.get(i)).getInt();
            if (idx < 0 || idx >= totalRows) continue;
            exclude[idx] = true;
        }
        int count = 0;
        for (boolean ex : exclude) {
            if (ex) continue;
            ++count;
        }
        int[] result = new int[count];
        int pos = 0;
        for (int i = 0; i < totalRows; ++i) {
            if (exclude[i]) continue;
            result[pos++] = i;
        }
        return result;
    }

    private static boolean appendColumns(BasicTable table, Vector[] columns) {
        try {
            if (columns.length == 0) {
                log.debug("No columns to append");
                return true;
            }
            int rowsToAdd = columns[0].rows();
            log.debug("Appending " + rowsToAdd + " rows to table with " + table.columns() + " columns");
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].rows() == rowsToAdd || table.getColumn(i) instanceof BasicArrayVector || table.getColumn(i) instanceof BasicAnyVector) continue;
                throw new IllegalArgumentException("All columns must have the same number of rows");
            }
            for (int col = 0; col < columns.length; ++col) {
                table.getColumn(col).Append(columns[col]);
            }
            log.debug("After append, table has " + table.rows() + " rows");
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in appendColumns: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static boolean updateRows(BasicTable table, Vector[] values, BasicIntVector rowIndices, List<String> columnNames) {
        try {
            log.debug("=== UPDATE ROWS DEBUG ===");
            log.debug("Table rows: " + table.rows());
            log.debug("Row indices count: " + rowIndices.rows());
            log.debug("Update values length: " + values.length);
            if (table.rows() == 0 && rowIndices.rows() > 0) {
                log.debug("Table is empty, converting update to append");
                return StreamingSQLResultUpdater.appendColumns(table, values);
            }
            for (int i = 0; i < rowIndices.rows(); ++i) {
                int rowIndex = ((BasicInt)rowIndices.get(i)).getInt();
                if (rowIndex < 0 || rowIndex >= table.rows()) {
                    log.debug("Row index " + rowIndex + " out of bounds, skipping");
                    continue;
                }
                log.debug("Updating row " + rowIndex);
                for (int colIndex = 0; colIndex < Math.min(values.length, table.columns()); ++colIndex) {
                    try {
                        Entity value = table.getColumn(colIndex) instanceof BasicArrayVector ? values[colIndex] : values[colIndex].get(i);
                        Vector tableColumn = table.getColumn(colIndex);
                        log.debug("  Updating column " + colIndex + " (type: " + (Object)((Object)tableColumn.getDataType()) + ")");
                        log.debug("    Old value: " + (tableColumn.rows() > rowIndex ? tableColumn.get(rowIndex).getString() : "N/A"));
                        log.debug("    New value: " + value.getString());
                        if (tableColumn instanceof BasicArrayVector) {
                            log.debug("    Detected BasicArrayVector, using enhanced set method");
                            if (!(value instanceof Vector)) {
                                System.err.println("    Error: BasicArrayVector requires Vector value, got: " + value.getClass().getSimpleName());
                                continue;
                            }
                        }
                        tableColumn.set(rowIndex, value);
                        Entity updatedValue = tableColumn.get(rowIndex);
                        log.debug("    Updated value: " + updatedValue.getString());
                        if (!updatedValue.getString().equals(value.getString())) {
                            System.err.println("    Warning: Update may not have taken effect!");
                            System.err.println("    Expected: " + value.getString());
                            System.err.println("    Actual: " + updatedValue.getString());
                            continue;
                        }
                        log.debug("    Update successful!");
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("  Error updating column " + colIndex + " at row " + rowIndex + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            log.debug("=== UPDATE ROWS COMPLETED ===");
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in updateRows: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    protected static class StreamingSQLResult {
        public BasicTable table;
        public BasicIntVector deleteLineMap;

        public StreamingSQLResult(BasicTable table, BasicIntVector deleteLineMap) {
            this.table = table;
            this.deleteLineMap = deleteLineMap;
        }
    }

    private static class DeleteLineMapWrapper {
        public BasicIntVector map;

        public DeleteLineMapWrapper(BasicIntVector map) {
            this.map = map;
        }
    }

    private static class LogType {
        public static final byte kUpdate = 0;
        public static final byte kAppend = 1;
        public static final byte kDelete = 2;
        public static final byte kInsert = 3;

        private LogType() {
        }
    }
}

