/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import com.xxdb.SimpleDBConnectionPoolConfig;
import com.xxdb.data.BasicInt;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBConnectionPool {
    private String hostName;
    private int port;
    private String userId;
    private String password;
    @Deprecated
    private int initialPoolSize;
    private int minimumPoolSize;
    private int maximumPoolSize;
    private int idleTimeout;
    private String initialScript;
    private boolean compress;
    private boolean useSSL;
    private boolean usePython;
    private boolean loadBalance;
    private boolean enableHighAvailability;
    private String[] highAvailabilitySites;
    private boolean reconnect = true;
    private int tryReconnectNums;
    private static final Logger log = LoggerFactory.getLogger(DBConnection.class);
    private final Queue<PoolEntry> poolEntries = new ConcurrentLinkedQueue<PoolEntry>();
    private final AtomicBoolean isPoolShutdown = new AtomicBoolean(false);
    private volatile boolean isPoolRunning = true;
    private Thread cleanupIdleConnsThread = null;

    public SimpleDBConnectionPool(SimpleDBConnectionPoolConfig simpleDBConnectionPoolConfig) {
        simpleDBConnectionPoolConfig.validate();
        this.hostName = simpleDBConnectionPoolConfig.getHostName();
        this.port = simpleDBConnectionPoolConfig.getPort();
        this.userId = simpleDBConnectionPoolConfig.getUserId();
        this.password = simpleDBConnectionPoolConfig.getPassword();
        this.minimumPoolSize = simpleDBConnectionPoolConfig.getMinimumPoolSize();
        this.maximumPoolSize = simpleDBConnectionPoolConfig.getMaximumPoolSize();
        this.idleTimeout = simpleDBConnectionPoolConfig.getIdleTimeout();
        this.initialScript = simpleDBConnectionPoolConfig.getInitialScript();
        this.compress = simpleDBConnectionPoolConfig.isCompress();
        this.useSSL = simpleDBConnectionPoolConfig.isUseSSL();
        this.usePython = simpleDBConnectionPoolConfig.isUsePython();
        this.loadBalance = simpleDBConnectionPoolConfig.isLoadBalance();
        this.enableHighAvailability = simpleDBConnectionPoolConfig.isEnableHighAvailability();
        this.highAvailabilitySites = simpleDBConnectionPoolConfig.getHighAvailabilitySites();
        this.tryReconnectNums = simpleDBConnectionPoolConfig.getTryReconnectNums();
        this.initPool();
    }

    private void initPool() {
        for (int i = 0; i < this.minimumPoolSize; ++i) {
            try {
                PoolEntry poolEntry = new PoolEntry(this.useSSL, this.compress, this.usePython, String.format("DolphinDBConnection_%d", i + 1));
                if (!poolEntry.entryConnect(this.hostName, this.port, this.userId, this.password, this.initialScript, this.enableHighAvailability, this.highAvailabilitySites, this.reconnect, this.loadBalance, this.tryReconnectNums)) {
                    throw new RuntimeException(String.format("Connection %s connect failure.", poolEntry.connectionName));
                }
                this.poolEntries.add(poolEntry);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Create connection pool failure, because " + e.getMessage(), e);
            }
        }
        this.cleanupIdleConnsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleDBConnectionPool.this.runCleanupTask();
            }
        });
        this.cleanupIdleConnsThread.setDaemon(true);
        this.cleanupIdleConnsThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleDBConnectionPool.this.close();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnection getConnection() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection pool has been closed.");
        }
        for (PoolEntry poolEntry : this.poolEntries) {
            if (!poolEntry.inUse.compareAndSet(false, true)) continue;
            return poolEntry;
        }
        SimpleDBConnectionPool simpleDBConnectionPool = this;
        synchronized (simpleDBConnectionPool) {
            if (this.poolEntries.size() < this.maximumPoolSize) {
                try {
                    PoolEntry poolEntry;
                    poolEntry = new PoolEntry(this.useSSL, this.compress, this.usePython, String.format("DolphinDBConnection_%d", this.poolEntries.size() + 1));
                    if (poolEntry.entryConnect(this.hostName, this.port, this.userId, this.password, this.initialScript, this.enableHighAvailability, this.highAvailabilitySites, this.reconnect, this.loadBalance, this.tryReconnectNums)) {
                        this.poolEntries.add(poolEntry);
                        if (poolEntry.inUse.compareAndSet(false, true)) {
                            return poolEntry;
                        }
                    } else {
                        log.error(String.format("Connection %s connect failure.", poolEntry.connectionName));
                    }
                }
                catch (IOException e) {
                    log.error("Failed to create new connection: " + e.getMessage());
                }
            }
        }
        throw new RuntimeException("No available idle connections.");
    }

    public int getActiveConnectionsCount() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection pool has been closed.");
        }
        return this.getActiveOrIdleCount(false);
    }

    public int getIdleConnectionsCount() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection pool has been closed.");
        }
        return this.getActiveOrIdleCount(true);
    }

    public int getTotalConnectionsCount() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection pool has been closed.");
        }
        return this.poolEntries.size();
    }

    public synchronized void manualCleanupIdleConnections() {
        int totalConnections = this.poolEntries.size();
        Iterator iterator = this.poolEntries.iterator();
        while (iterator.hasNext()) {
            PoolEntry poolEntry = (PoolEntry)iterator.next();
            if (!poolEntry.isIdle() || totalConnections <= this.minimumPoolSize) continue;
            poolEntry.release();
            iterator.remove();
            --totalConnections;
        }
    }

    public void close() {
        this.isPoolRunning = false;
        this.cleanupIdleConnsThread.interrupt();
        try {
            this.cleanupIdleConnsThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.isPoolShutdown.getAndSet(true)) {
            log.info("Closing the connection pool......");
            if (this.poolEntries.size() != 0) {
                for (PoolEntry poolEntry : this.poolEntries) {
                    poolEntry.release();
                }
            }
            log.info("Closing the connection pool finished.");
        } else {
            log.info("The connection pool is closed.");
        }
    }

    public boolean isClosed() {
        return this.isPoolShutdown.get();
    }

    private synchronized void internalCleanupIdleConnections() {
        long currentTime = System.currentTimeMillis();
        int totalConnections = this.poolEntries.size();
        Iterator iterator = this.poolEntries.iterator();
        while (iterator.hasNext()) {
            PoolEntry poolEntry = (PoolEntry)iterator.next();
            if (!poolEntry.isIdle() || currentTime - poolEntry.getLastUsedTime() <= (long)this.idleTimeout || totalConnections <= this.minimumPoolSize) continue;
            poolEntry.release();
            iterator.remove();
            --totalConnections;
        }
    }

    private void runCleanupTask() {
        while (this.isPoolRunning) {
            try {
                this.internalCleanupIdleConnections();
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to clean up idle connections: " + e.getMessage());
            }
        }
    }

    private int getActiveOrIdleCount(boolean isIdle) {
        int count = 0;
        for (PoolEntry poolEntry : this.poolEntries) {
            if (poolEntry.isIdle() != isIdle) continue;
            ++count;
        }
        return count;
    }

    class PoolEntry
    extends DBConnection {
        AtomicBoolean inUse;
        String connectionName;
        private long lastUsedTime;

        PoolEntry(boolean useSSL, boolean compress, boolean usePython, String connectionName) {
            super(false, useSSL, compress, usePython);
            this.inUse = new AtomicBoolean(false);
            this.connectionName = connectionName;
        }

        private boolean entryConnect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect, boolean enableLoadBalance, int tryReconnectNums) throws IOException {
            boolean isConnected = super.connect(hostName, port, userId, password, initialScript, enableHighAvailability, highAvailabilitySites, reconnect, enableLoadBalance, tryReconnectNums);
            if (isConnected) {
                this.lastUsedTime = System.currentTimeMillis();
            }
            return isConnected;
        }

        private boolean isIdle() {
            return !this.inUse.get();
        }

        private long getLastUsedTime() {
            return this.lastUsedTime;
        }

        @Override
        public void setLoadBalance(boolean loadBalance) {
            throw new RuntimeException("The loadBalance configuration of connection in connection pool can only be set in SimpleDBConnectionPoolConfig.");
        }

        @Override
        public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean enableHighAvailability, String[] highAvailabilitySites, boolean reconnect, boolean enableLoadBalance) throws IOException {
            throw new RuntimeException("The connection in connection pool can only connect by pool.");
        }

        @Override
        public void login(String userId, String password, boolean enableEncryption) throws IOException {
            throw new RuntimeException("The connection in connection pool can only login by pool.");
        }

        @Override
        public void close() {
            if (this.isBusy()) {
                log.error("Cannot release the connection, is running now.");
            } else {
                try {
                    BasicInt ret = (BasicInt)this.run("1+1", true);
                    if (!ret.isNull() && ret.getInt() == 2) {
                        this.inUse.compareAndSet(true, false);
                        this.lastUsedTime = System.currentTimeMillis();
                    } else {
                        log.error("Cannot release memory, release connection failure.");
                    }
                }
                catch (Exception e) {
                    log.error("Cannot release memory, because " + e.getMessage());
                }
            }
        }

        private void release() {
            super.close();
        }
    }
}

