/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class BasicAnyVector
extends AbstractVector {
    private List<Entity> values;

    public BasicAnyVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = new ArrayList<Entity>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(null);
        }
    }

    protected BasicAnyVector(Entity[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = new ArrayList<Entity>(Arrays.asList(array));
    }

    protected BasicAnyVector(ExtendedDataInput in) throws IOException {
        super(Entity.DATA_FORM.DF_VECTOR);
        int rows = in.readInt();
        int cols = in.readInt();
        this.values = new ArrayList<Entity>(rows);
        for (int i = 0; i < rows; ++i) {
            boolean extended;
            short flag = in.readShort();
            int form = flag >> 8;
            int type = flag & 0xFF;
            boolean bl = extended = type >= 128;
            if (type >= 128) {
                type -= 128;
            }
            Entity obj = BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.values()[form], Entity.DATA_TYPE.valueOf(type), in, extended);
            this.values.add(obj);
        }
    }

    public Entity getEntity(int index) {
        return this.values.get(index);
    }

    @Override
    public Entity get(int index) {
        return this.values.get(index);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        Entity[] sub = new Entity[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values.get(indices[i]);
        }
        return new BasicAnyVector(sub, false);
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values.set(index, value);
    }

    @Override
    public void set(int index, Object value) {
        if (!(value instanceof Entity)) {
            throw new RuntimeException("BasicAnyVector.set(int index, Object value) only supports Entity objects.");
        }
        this.values.set(index, (Entity)value);
    }

    public void setEntity(int index, Entity value) {
        this.values.set(index, value);
    }

    @Override
    public Vector combine(Vector vector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull(int index) {
        return this.values.get(index) == null || this.values.get(index).isScalar() && ((Scalar)this.values.get(index)).isNull();
    }

    @Override
    public void setNull(int index) {
        this.values.set(index, new Void());
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.MIXED;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_ANY;
    }

    @Override
    public int rows() {
        return this.values.size();
    }

    @Override
    @JsonIgnore
    public int getUnitLength() {
        throw new RuntimeException("BasicAnyVector.getUnitLength not supported.");
    }

    public void addRange(Object[] valueList) {
        throw new RuntimeException("AnyVector not support addRange");
    }

    @Override
    public void Append(Scalar value) {
        this.values.add(value);
    }

    @Override
    public void Append(Vector value) {
        this.values.add(value);
    }

    @Override
    public void checkCapacity(int requiredCapacity) {
        throw new RuntimeException("BasicAnyVector not support checkCapacity.");
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder("(");
        int size = Math.min(10, this.rows());
        if (size > 0) {
            sb.append(this.getEntity(0).getString());
        }
        for (int i = 1; i < size; ++i) {
            sb.append(',');
            sb.append(this.getEntity(i).getString());
        }
        if (size < this.rows()) {
            sb.append(",...");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Class<?> getElementClass() {
        return Entity.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        throw new RuntimeException("BasicAnyVector.serialize not supported.");
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        throw new RuntimeException("BasicAnyVector.serialize not supported.");
    }

    @Override
    public void add(Object value) {
        throw new RuntimeException("AnyVector not support add");
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (Entity value : this.values) {
            if (!Objects.nonNull(value)) continue;
            value.write(out);
        }
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicAnyVector.asof not supported.");
    }
}

