/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;

public class BasicDateTimeVector
extends BasicIntVector {
    public BasicDateTimeVector(int size) {
        super(size);
    }

    public BasicDateTimeVector(int size, int capacity) {
        super(size, capacity);
    }

    public BasicDateTimeVector(List<Integer> list) {
        super(list);
    }

    public BasicDateTimeVector(int[] array) {
        super(array);
    }

    protected BasicDateTimeVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicDateTimeVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicDateTimeVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATETIME;
    }

    @Override
    public Entity get(int index) {
        return new BasicDateTime(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicDateTimeVector(this.getSubArray(indices), false);
    }

    public LocalDateTime getDateTime(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseDateTime(this.getInt(index));
    }

    @Override
    public void set(int index, Object value) {
        if (value == null) {
            this.setNull(index);
        } else if (value instanceof Integer) {
            this.setInt(index, (Integer)value);
        } else if (value instanceof LocalDateTime) {
            this.setDateTime(index, (LocalDateTime)value);
        } else if (value instanceof Calendar) {
            this.setInt(index, Utils.countDTSeconds((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalDateTime, Calendar, Integer or null is supported.");
        }
    }

    public void setDateTime(int index, LocalDateTime dt) {
        this.setInt(index, Utils.countSeconds(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDateTime.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDateTimeVector v = (BasicDateTimeVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicDateTimeVector(newValue);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (int val : data) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public void add(Object value) {
        if (value == null) {
            this.add(Integer.MIN_VALUE);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof LocalDateTime) {
            this.add(Utils.countSeconds((LocalDateTime)value));
        } else if (value instanceof Calendar) {
            this.add(Utils.countDTSeconds((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalDateTime, Calendar, Integer or null is supported.");
        }
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicDateTimeVector)value).getdataArray());
    }
}

