/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.List;

public class BasicDateVector
extends BasicIntVector {
    public BasicDateVector(int size) {
        super(size);
    }

    public BasicDateVector(int size, int capacity) {
        super(size, capacity);
    }

    public BasicDateVector(List<Integer> list) {
        super(list);
    }

    public BasicDateVector(int[] array) {
        super(array);
    }

    protected BasicDateVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicDateVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicDateVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATE;
    }

    @Override
    public Entity get(int index) {
        return new BasicDate(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicDateVector(this.getSubArray(indices), false);
    }

    public LocalDate getDate(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseDate(this.getInt(index));
    }

    @Override
    public void set(int index, Object value) {
        if (value == null) {
            this.setNull(index);
        } else if (value instanceof Integer) {
            this.setInt(index, (Integer)value);
        } else if (value instanceof LocalDate) {
            this.setDate(index, (LocalDate)value);
        } else if (value instanceof Calendar) {
            this.setInt(index, Utils.countDays((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalDate, Calendar, Integer or null is supported.");
        }
    }

    public void setDate(int index, LocalDate date) {
        this.setInt(index, Utils.countDays(date));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDate.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDateVector v = (BasicDateVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicDateVector(newValue);
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (int val : data) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public void add(Object value) {
        if (value == null) {
            this.add(Integer.MIN_VALUE);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof LocalDate) {
            this.add(Utils.countDays((LocalDate)value));
        } else if (value instanceof Calendar) {
            this.add(Utils.countDays((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalDate, Calendar, Integer or null is supported.");
        }
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicDateVector)value).getdataArray());
    }
}

