/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicString;
import com.xxdb.data.Dictionary;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BasicDictionary
extends AbstractEntity
implements Dictionary {
    private Map<Entity, Entity> dict;
    private Entity.DATA_TYPE keyType;
    private Entity.DATA_TYPE valueType;

    public BasicDictionary(Entity.DATA_TYPE valueType, ExtendedDataInput in) throws IOException {
        boolean extended;
        this.valueType = valueType;
        short flag = in.readShort();
        int form = flag >> 8;
        int type = flag & 0xFF;
        boolean bl = extended = type >= 128;
        if (type >= 128) {
            type -= 128;
        }
        if (form != Entity.DATA_FORM.DF_VECTOR.ordinal()) {
            throw new IOException("The form of dictionary keys must be vector");
        }
        this.keyType = Entity.DATA_TYPE.valueOf(type);
        Vector keys = (Vector)BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.DF_VECTOR, this.keyType, in, extended);
        flag = in.readShort();
        form = flag >> 8;
        type = flag & 0xFF;
        boolean bl2 = extended = type >= 128;
        if (type >= 128) {
            type -= 128;
        }
        if (form != Entity.DATA_FORM.DF_VECTOR.ordinal()) {
            throw new IOException("The form of dictionary values must be vector");
        }
        valueType = Entity.DATA_TYPE.valueOf(type);
        Vector values = (Vector)BasicEntityFactory.instance().createEntity(Entity.DATA_FORM.DF_VECTOR, valueType, in, extended);
        if (keys.rows() != values.rows()) {
            throw new IOException("The key size doesn't equate to value size.");
        }
        int size = keys.rows();
        int capacity = (int)((double)size / 0.75);
        this.dict = new HashMap<Entity, Entity>(capacity);
        if (values.getDataType() == Entity.DATA_TYPE.DT_ANY) {
            BasicAnyVector entityValues = (BasicAnyVector)values;
            for (int i = 0; i < size; ++i) {
                this.dict.put(keys.get(i), entityValues.getEntity(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.dict.put(keys.get(i), values.get(i));
            }
        }
    }

    public BasicDictionary(Entity.DATA_TYPE keyType, Entity.DATA_TYPE valueType, int capacity) {
        if (keyType == Entity.DATA_TYPE.DT_VOID || keyType == Entity.DATA_TYPE.DT_ANY || keyType == Entity.DATA_TYPE.DT_DICTIONARY) {
            throw new IllegalArgumentException("Invalid keyType: " + keyType.name());
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.dict = new HashMap<Entity, Entity>();
    }

    public BasicDictionary(Entity.DATA_TYPE keyType, Entity.DATA_TYPE valueType) {
        this(keyType, valueType, 0);
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_DICTIONARY;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return this.getDataCategory(this.valueType);
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.valueType;
    }

    @Override
    public int rows() {
        return this.dict.size();
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public Entity.DATA_TYPE getKeyDataType() {
        return this.keyType;
    }

    @Override
    public Entity get(Scalar key) {
        return this.dict.get(key);
    }

    @Override
    public boolean put(Scalar key, Entity value) {
        if (key.getDataType() != this.getKeyDataType() || this.getDataType() != Entity.DATA_TYPE.DT_ANY && value.getDataType() != this.getDataType()) {
            return false;
        }
        this.dict.put(key, value);
        return true;
    }

    public Entity get(String key) {
        return this.dict.get(new BasicString(key));
    }

    public Set<Entity> keys() {
        return this.dict.keySet();
    }

    public Collection<Entity> values() {
        return this.dict.values();
    }

    public Set<Map.Entry<Entity, Entity>> entrySet() {
        return this.dict.entrySet();
    }

    @Override
    public String getString() {
        if (this.valueType == Entity.DATA_TYPE.DT_ANY) {
            StringBuilder content = new StringBuilder();
            Set<Map.Entry<Entity, Entity>> entries = this.dict.entrySet();
            Iterator<Map.Entry<Entity, Entity>> it = entries.iterator();
            for (int count = 0; it.hasNext() && count < 20; ++count) {
                Map.Entry<Entity, Entity> entry = it.next();
                content.append(entry.getKey().getString());
                content.append("->");
                Entity.DATA_FORM form = entry.getValue().getDataForm();
                if (form == Entity.DATA_FORM.DF_MATRIX || form == Entity.DATA_FORM.DF_TABLE) {
                    content.append("\n");
                } else if (form == Entity.DATA_FORM.DF_DICTIONARY) {
                    content.append("{\n");
                }
                content.append(entry.getValue().getString());
                if (form == Entity.DATA_FORM.DF_DICTIONARY) {
                    content.append("}");
                }
                content.append("\n");
            }
            if (it.hasNext()) {
                content.append("...\n");
            }
            return content.toString();
        }
        StringBuilder sbKeys = new StringBuilder("{");
        StringBuilder sbValues = new StringBuilder("{");
        Set<Map.Entry<Entity, Entity>> entries = this.dict.entrySet();
        Iterator<Map.Entry<Entity, Entity>> it = entries.iterator();
        if (it.hasNext()) {
            Map.Entry<Entity, Entity> entry = it.next();
            sbKeys.append(entry.getKey().getString());
            sbValues.append(entry.getValue().getString());
        }
        for (int count = 1; it.hasNext() && count < 20; ++count) {
            Map.Entry<Entity, Entity> entry = it.next();
            sbKeys.append(',');
            sbKeys.append(entry.getKey().getString());
            sbValues.append(',');
            sbValues.append(entry.getValue().getString());
        }
        if (it.hasNext()) {
            sbKeys.append("...");
            sbValues.append("...");
        }
        sbKeys.append("}");
        sbValues.append("}");
        return sbKeys.toString() + "->" + sbValues.toString();
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        if (this.valueType == Entity.DATA_TYPE.DT_DICTIONARY) {
            throw new IOException("Can't streamlize the dictionary with value type " + this.valueType.name());
        }
        BasicEntityFactory factory = new BasicEntityFactory();
        Vector keys = factory.createVectorWithDefaultValue(this.keyType, this.dict.size(), -1);
        Vector values = this.valueType == Entity.DATA_TYPE.DT_ANY ? new BasicAnyVector(this.dict.size()) : factory.createVectorWithDefaultValue(this.valueType, this.dict.size(), -1);
        int index = 0;
        try {
            for (Map.Entry<Entity, Entity> entry : this.dict.entrySet()) {
                keys.set(index, entry.getKey());
                values.set(index, entry.getValue());
                ++index;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        int flag = (Entity.DATA_FORM.DF_DICTIONARY.ordinal() << 8) + this.getDataType().getValue();
        out.writeShort(flag);
        keys.write(out);
        values.write(out);
    }
}

