/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.List;

public class BasicSecondVector
extends BasicIntVector {
    public BasicSecondVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicSecondVector(int size, int capacity) {
        super(size, capacity);
    }

    public BasicSecondVector(List<Integer> list) {
        super(list);
    }

    public BasicSecondVector(int[] array) {
        super(array);
    }

    public BasicSecondVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicSecondVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicSecondVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SECOND;
    }

    @Override
    public Entity get(int index) {
        return new BasicSecond(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicSecondVector(this.getSubArray(indices), false);
    }

    public LocalTime getSecond(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseSecond(this.getInt(index));
    }

    @Override
    public void set(int index, Object value) {
        if (value == null) {
            this.setNull(index);
        } else if (value instanceof Integer) {
            this.setInt(index, (Integer)value);
        } else if (value instanceof LocalTime) {
            this.setSecond(index, (LocalTime)value);
        } else if (value instanceof Calendar) {
            this.setInt(index, Utils.countSeconds((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalTime, Calendar, Integer or null is supported.");
        }
    }

    public void setSecond(int index, LocalTime time) {
        this.setInt(index, Utils.countSeconds(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicSecond.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicSecondVector v = (BasicSecondVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicSecondVector(newValue);
    }

    @Override
    public void add(Object value) {
        if (value == null) {
            this.add(Integer.MIN_VALUE);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof LocalTime) {
            this.add(Utils.countSeconds((LocalTime)value));
        } else if (value instanceof Calendar) {
            this.add(Utils.countSeconds((Calendar)value));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName() + ". Only LocalTime, Calendar, Integer or null is supported.");
        }
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicSecondVector)value).getdataArray());
    }
}

