/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtendedDataOutputStream
extends FilterOutputStream
implements ExtendedDataOutput {
    private static final int UTF8_STRING_LIMIT = 65535;
    protected static final int BUF_SIZE = 4096;
    protected byte[] buf;
    protected static final int longBufSize = 512;
    protected static final int intBufSize = 1024;
    protected static final int doubleBufSize = 512;
    protected int[] intBuf;
    protected long[] longBuf;
    protected double[] doubleBuf;
    private static final Logger log = LoggerFactory.getLogger(AbstractExtendedDataOutputStream.class);

    public AbstractExtendedDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.write(b);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String value) throws IOException {
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] newValueBytes = AbstractExtendedDataOutputStream.getResolveZeroByteArray(valueBytes);
        this.writeShort(newValueBytes.length);
        this.write(newValueBytes, 0, newValueBytes.length);
        this.write(0);
    }

    @Override
    public void writeString(String value) throws IOException {
        int len = value.length();
        if (len >= 262144) {
            throw new RuntimeException("Serialized string length must less than 256k bytes.");
        }
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] newValueBytes = AbstractExtendedDataOutputStream.getResolveZeroByteArray(valueBytes);
        this.write(newValueBytes, 0, newValueBytes.length);
        this.write(0);
    }

    @Override
    public void writeBlob(byte[] value) throws IOException {
        this.writeInt(value.length);
        this.write(value);
    }

    public static int getUTFlength(String value, int start, int sum) throws IOException {
        int len = value.length();
        for (int i = start; i < len; ++i) {
            char c = value.charAt(i);
            if (Character.isHighSurrogate(c) && i + 1 < len && Character.isLowSurrogate(value.charAt(i + 1))) {
                sum += 4;
                ++i;
                continue;
            }
            if (c <= '\u007f') {
                ++sum;
                continue;
            }
            if (c <= '\u07ff') {
                sum += 2;
                continue;
            }
            sum += 3;
        }
        return sum;
    }

    @Override
    public void writeShortArray(short[] A) throws IOException {
        this.writeShortArray(A, 0, A.length);
    }

    @Override
    public void writeIntArray(int[] A) throws IOException {
        this.writeIntArray(A, 0, A.length);
    }

    @Override
    public void writeLongArray(long[] A) throws IOException {
        this.writeLongArray(A, 0, A.length);
    }

    @Override
    public void writeDoubleArray(double[] A) throws IOException {
        this.writeDoubleArray(A, 0, A.length);
    }

    @Override
    public void writeDoubleArray(double[] A, int startIdx, int len) throws IOException {
        if (this.longBuf == null) {
            this.longBuf = new long[512];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 512) {
                this.writeLongArray(this.longBuf, 0, pos);
                pos = 0;
            }
            this.longBuf[pos++] = Double.doubleToLongBits(A[i]);
        }
        if (pos > 0) {
            this.writeLongArray(this.longBuf, 0, pos);
        }
    }

    @Override
    public void writeFloatArray(float[] A) throws IOException {
        this.writeFloatArray(A, 0, A.length);
    }

    @Override
    public void writeFloatArray(float[] A, int startIdx, int len) throws IOException {
        if (this.intBuf == null) {
            this.intBuf = new int[1024];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 1024) {
                this.writeIntArray(this.intBuf, 0, pos);
                pos = 0;
            }
            this.intBuf[pos++] = Float.floatToIntBits(A[i]);
        }
        if (pos > 0) {
            this.writeIntArray(this.intBuf, 0, pos);
        }
    }

    @Override
    public void writeStringArray(String[] A) throws IOException {
        this.writeStringArray(A, 0, A.length);
    }

    @Override
    public void writeStringArray(String[] A, int startIdx, int len) throws IOException {
        int end = startIdx + len;
        for (int j = startIdx; j < end; ++j) {
            String value = A[j];
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            byte[] newValueBytes = AbstractExtendedDataOutputStream.getResolveZeroByteArray(valueBytes);
            this.write(newValueBytes, 0, newValueBytes.length);
            this.write(0);
        }
    }

    @Override
    public void writeLong2Array(Long2[] A) throws IOException {
        this.writeLong2Array(A, 0, A.length);
    }

    @Override
    public void writeDouble2Array(Double2[] A, int startIdx, int len) throws IOException {
        if (this.doubleBuf == null) {
            this.doubleBuf = new double[512];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 512) {
                this.writeDoubleArray(this.doubleBuf, 0, pos);
                pos = 0;
            }
            this.doubleBuf[pos++] = A[i].x;
            this.doubleBuf[pos++] = A[i].y;
        }
        if (pos > 0) {
            this.writeDoubleArray(this.doubleBuf, 0, pos);
        }
    }

    @Override
    public void writeDouble2Array(Double2[] A) throws IOException {
        this.writeDouble2Array(A, 0, A.length);
    }

    public static byte[] getResolveZeroByteArray(byte[] originalArray) {
        byte[] newArray;
        int indexOfZero = -1;
        for (int i = 0; i < originalArray.length; ++i) {
            if (originalArray[i] != 0) continue;
            indexOfZero = i;
            break;
        }
        if (indexOfZero != -1) {
            log.warn("The input String contains '\u0000', it will be dropped start from '\u0000' to last.");
            newArray = new byte[indexOfZero];
            System.arraycopy(originalArray, 0, newArray, 0, indexOfZero);
        } else {
            newArray = originalArray;
        }
        return newArray;
    }
}

