/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageHandler;
import com.xxdb.streaming.client.QueueManager;
import com.xxdb.streaming.client.Site;
import com.xxdb.streaming.client.StreamDeserializer;
import java.io.IOException;
import java.net.SocketException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPooledClient
extends AbstractClient {
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private ExecutorService threadPool;
    private int threadCount = -1;
    private static final Logger log = LoggerFactory.getLogger(ThreadPooledClient.class);
    private HashMap<String, QueueHandlerBinder> queueHandlers = new HashMap();

    public ThreadPooledClient() throws SocketException {
        this("", 8849, CORES);
    }

    public ThreadPooledClient(int threadCount) throws SocketException {
        this("", 0, threadCount);
    }

    public ThreadPooledClient(int subscribePort, int threadCount) throws SocketException {
        this("", subscribePort, threadCount);
    }

    public ThreadPooledClient(String subscribeHost, int subscribePort, int threadCount) throws SocketException {
        super(subscribeHost, subscribePort);
        if (threadCount <= 0) {
            throw new RuntimeException("The 'threadCount' parameter cannot be less than or equal to zero.");
        }
        this.threadCount = threadCount;
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        new Thread(){
            private LinkedList<IMessage> backlog = new LinkedList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillBacklog() {
                boolean filled = false;
                HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                synchronized (hashMap) {
                    for (String topic : ThreadPooledClient.this.queueHandlers.keySet()) {
                        List messages = (List)((QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(topic)).queue.poll();
                        if (messages == null) continue;
                        this.backlog.addAll(messages);
                        filled = true;
                    }
                }
                return filled;
            }

            private void refill() {
                int count = 200;
                while (!this.fillBacklog()) {
                    if (count > 0) {
                        Thread.yield();
                    } else {
                        LockSupport.parkNanos(1000000L);
                    }
                    --count;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    IMessage msg;
                    while ((msg = this.backlog.poll()) != null) {
                        QueueHandlerBinder binder;
                        HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                        synchronized (hashMap) {
                            binder = (QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(msg.getTopic());
                        }
                        ThreadPooledClient.this.threadPool.execute(new HandlerRunner(binder.handler, msg));
                    }
                    this.refill();
                }
            }
        }.start();
    }

    @Override
    protected boolean doReconnect(Site site) {
        if (!AbstractClient.ifUseBackupSite) {
            this.threadPool.shutdownNow();
            try {
                Thread.sleep(1000L);
                this.subscribe(site.host, site.port, site.tableName, site.actionName, site.handler, site.msgId + 1L, true, site.filter, site.deserializer, site.allowExistTopic, site.userName, site.passWord);
                log.info("Successfully reconnected and subscribed " + site.host + ":" + site.port + "/" + site.tableName + site.actionName);
                return true;
            }
            catch (Exception ex) {
                Object[] hostPort = new Object[2];
                if (this.getNewLeader(ex.getMessage(), hostPort)) {
                    log.warn("In reconnect: Got NotLeaderException, switch to leader node [" + hostPort[0] + ":" + hostPort[1] + "] for subscription");
                    this.haStreamTableInfo.add(new AbstractClient.HAStreamTableInfo(this, site.host, site.port, site.tableName, site.actionName, (String)hostPort[0], (Integer)hostPort[1]));
                    site.host = (String)hostPort[0];
                    site.port = (Integer)hostPort[1];
                } else {
                    log.error("Unable to subscribe table. Will try again after 1 seconds.");
                    ex.printStackTrace();
                }
                return false;
            }
        }
        log.info("ThreadPooledClient doReconnect: " + site.host + ":" + site.port);
        try {
            Thread.sleep(1000L);
            this.backupSitesSubscribeInternal(site.host, site.port, site.tableName, site.actionName, site.handler, site.msgId + 1L, true, site.filter, site.deserializer, site.allowExistTopic, site.userName, site.passWord, false);
            String topicStr = site.host + ":" + site.port + "/" + site.tableName + "/" + site.actionName;
            String curTopic = (String)this.tableNameToTrueTopic.get(topicStr);
            BlockingQueue<List<IMessage>> queue = this.queueManager.addQueue(curTopic);
            this.queueManager.changeQueue(curTopic, this.lastQueue);
            QueueHandlerBinder queueHandlerBinder = this.queueHandlers.get(this.lastBackupSiteTopic);
            this.queueHandlers.put(curTopic, queueHandlerBinder);
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.threadPool.shutdownNow();
                    if (!this.threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        log.error("last threadPool did not terminate.");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (this.threadPool.isTerminated()) {
                this.threadPool = Executors.newFixedThreadPool(this.threadCount);
            }
            log.info("Successfully reconnected and subscribed " + site.host + ":" + site.port + "/" + site.tableName + site.actionName);
            return true;
        }
        catch (Exception ex) {
            Object[] hostPort = new Object[2];
            if (this.getNewLeader(ex.getMessage(), hostPort)) {
                log.warn("In reconnect: Got NotLeaderException, switch to leader node [" + hostPort[0] + ":" + hostPort[1] + "] for subscription");
                this.haStreamTableInfo.add(new AbstractClient.HAStreamTableInfo(this, site.host, site.port, site.tableName, site.actionName, (String)hostPort[0], (Integer)hostPort[1]));
                site.host = (String)hostPort[0];
                site.port = (Integer)hostPort[1];
            } else {
                log.error("Unable to subscribe table. Will try again after 1 seconds.");
                ex.printStackTrace();
            }
            return false;
        }
    }

    protected void backupSitesSubscribeInternal(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String password, boolean createSubInfo) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, password, false, createSubInfo);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord, boolean msgAsTable) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, msgAsTable);
        if (!this.haStreamTableInfo.isEmpty()) {
            List list = this.haStreamTableInfo;
            synchronized (list) {
                AbstractClient.HAStreamTableInfo matchedInfo = null;
                for (AbstractClient.HAStreamTableInfo info : this.haStreamTableInfo) {
                    if (!info.getFollowIp().equals(host) || info.getFollowPort() != port || !info.getTableName().equals(tableName) || !info.getActionName().equals(actionName)) continue;
                    matchedInfo = info;
                    break;
                }
                if (matchedInfo != null) {
                    host = matchedInfo.getLeaderIp();
                    port = matchedInfo.getLeaderPort();
                }
            }
        }
        String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
        List<String> usr = Arrays.asList(userName, passWord);
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableNameToTrueTopic.get(topicStr), new QueueHandlerBinder(queue, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord, boolean msgAsTable, List<String> backupSites, int resubscribeInterval, boolean subOnce) throws IOException {
        if (resubscribeInterval < 0) {
            resubscribeInterval = 100;
        }
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, msgAsTable, backupSites, resubscribeInterval, subOnce);
        if (!this.haStreamTableInfo.isEmpty()) {
            List list = this.haStreamTableInfo;
            synchronized (list) {
                AbstractClient.HAStreamTableInfo matchedInfo = null;
                for (AbstractClient.HAStreamTableInfo info : this.haStreamTableInfo) {
                    if (!info.getFollowIp().equals(host) || info.getFollowPort() != port || !info.getTableName().equals(tableName) || !info.getActionName().equals(actionName)) continue;
                    matchedInfo = info;
                    break;
                }
                if (matchedInfo != null) {
                    host = matchedInfo.getLeaderIp();
                    port = matchedInfo.getLeaderPort();
                }
            }
        }
        String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableNameToTrueTopic.get(topicStr), new QueueHandlerBinder(queue, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic, String userName, String passWord, boolean msgAsTable, List<String> backupSites) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, userName, passWord, msgAsTable, backupSites, 100, false);
        String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableNameToTrueTopic.get(topicStr), new QueueHandlerBinder(queue, handler));
        }
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, boolean allowExistTopic, String userName, String passWord) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, null, allowExistTopic, userName, passWord);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer, boolean allowExistTopic) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, allowExistTopic, "", "");
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, boolean allowExistTopic) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, null, allowExistTopic);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, StreamDeserializer deserializer) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, filter, deserializer, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, null, null, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, Vector filter) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false, filter, null, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset, reconnect);
    }

    public void unsubscribe(String host, int port, String tableName, String actionName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, actionName);
    }

    public void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInternal(String host, int port, String tableName, String actionName) throws IOException {
        String originalFullTableName = host + ":" + port + "/" + tableName + "/" + actionName;
        log.debug("Starting unsubscribe process for " + originalFullTableName);
        if (!ifUseBackupSite) {
            DBConnection dbConn = new DBConnection();
            if (!this.haStreamTableInfo.isEmpty()) {
                List list = this.haStreamTableInfo;
                synchronized (list) {
                    AbstractClient.HAStreamTableInfo matchedInfo = null;
                    for (AbstractClient.HAStreamTableInfo info : this.haStreamTableInfo) {
                        if (!info.getFollowIp().equals(host) || info.getFollowPort() != port || !info.getTableName().equals(tableName) || !info.getActionName().equals(actionName)) continue;
                        matchedInfo = info;
                        break;
                    }
                    if (matchedInfo != null) {
                        log.debug("Found HA matched info, switching from " + host + ":" + port + " to leader " + matchedInfo.getLeaderIp() + ":" + matchedInfo.getLeaderPort());
                        host = matchedInfo.getLeaderIp();
                        port = matchedInfo.getLeaderPort();
                    }
                }
            }
            List<String> tp = Arrays.asList(host, String.valueOf(port), tableName, actionName);
            List usr = (List)this.users.get(tp);
            String user = (String)usr.get(0);
            String pwd = (String)usr.get(1);
            log.debug("Connecting to server " + host + ":" + port + " to send unsubscribe signal for " + originalFullTableName);
            if (!user.equals("")) {
                dbConn.connect(host, port, user, pwd);
            } else {
                dbConn.connect(host, port);
            }
            log.debug("Connected to server " + host + ":" + port + " successfully");
            try {
                String topic;
                String fullTableName = host + ":" + port + "/" + tableName + "/" + actionName;
                AbstractMap abstractMap = this.tableNameToTrueTopic;
                synchronized (abstractMap) {
                    topic = (String)this.tableNameToTrueTopic.get(fullTableName);
                    log.debug("Retrieved topic from tableNameToTrueTopic: " + topic + " for " + (String)fullTableName);
                }
                abstractMap = this.trueTopicToSites;
                synchronized (abstractMap) {
                    Site[] sites = (Site[])this.trueTopicToSites.get(topic);
                    if (sites == null || sites.length == 0) {
                        log.warn("No sites found for topic: " + topic);
                    } else {
                        log.info("Marking " + sites.length + " site(s) as closed for topic: " + topic + " BEFORE sending stopPublishTable");
                        for (int i = 0; i < sites.length; ++i) {
                            sites[i].closed = true;
                            log.debug("Site " + i + " marked as closed: " + sites[i].host + ":" + sites[i].port);
                        }
                    }
                }
                String localIP = this.listeningHost;
                if (localIP.equals("")) {
                    localIP = dbConn.getLocalAddress().getHostAddress();
                }
                ArrayList<Entity> params = new ArrayList<Entity>();
                params.add(new BasicString(localIP));
                params.add(new BasicInt(this.listeningPort));
                params.add(new BasicString(tableName));
                params.add(new BasicString(actionName));
                log.debug("Sending stopPublishTable command with params: localIP=" + localIP + ", listeningPort=" + this.listeningPort + ", tableName=" + tableName + ", actionName=" + actionName);
                dbConn.run("stopPublishTable", params);
                log.debug("stopPublishTable command executed successfully for " + originalFullTableName);
                QueueManager i = this.queueManager;
                synchronized (i) {
                    this.queueManager.removeQueue(topic);
                    log.debug("Queue removed from queueManager for topic: " + topic);
                }
                log.debug("Successfully unsubscribed table " + (String)fullTableName);
            }
            catch (Exception ex) {
                log.error("Error occurred during unsubscribe for " + originalFullTableName, (Throwable)ex);
                throw ex;
            }
            finally {
                dbConn.close();
                log.debug("DBConnection closed for " + originalFullTableName);
                String topicStr = host + ":" + port + "/" + tableName + "/" + actionName;
                HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
                synchronized (hashMap) {
                    this.queueHandlers.remove(topicStr);
                }
                log.debug("Unsubscribe process completed for " + originalFullTableName);
            }
        }
        log.debug("Using backupSite mode for unsubscribe");
        String originHost = host;
        int originPort = port;
        ThreadPooledClient threadPooledClient = this;
        synchronized (threadPooledClient) {
            Object topic;
            DBConnection dbConn = new DBConnection();
            if (!this.currentSiteIndexMap.isEmpty()) {
                topic = (String)this.tableNameToTrueTopic.get(host + ":" + port + "/" + tableName + "/" + actionName);
                Integer currentSiteIndex = (Integer)this.currentSiteIndexMap.get(topic);
                Site[] sites = (Site[])this.trueTopicToSites.get(topic);
                log.debug("Switching to current site index " + currentSiteIndex + ": " + sites[currentSiteIndex.intValue()].host + ":" + sites[currentSiteIndex.intValue()].port);
                host = sites[currentSiteIndex.intValue()].host;
                port = sites[currentSiteIndex.intValue()].port;
            }
            if (!this.haStreamTableInfo.isEmpty()) {
                topic = this.haStreamTableInfo;
                synchronized (topic) {
                    AbstractClient.HAStreamTableInfo matchedInfo = null;
                    for (AbstractClient.HAStreamTableInfo info : this.haStreamTableInfo) {
                        if (!info.getFollowIp().equals(host) || info.getFollowPort() != port || !info.getTableName().equals(tableName) || !info.getActionName().equals(actionName)) continue;
                        matchedInfo = info;
                        break;
                    }
                    if (matchedInfo != null) {
                        log.debug("Found HA matched info, switching from " + host + ":" + port + " to leader " + matchedInfo.getLeaderIp() + ":" + matchedInfo.getLeaderPort());
                        host = matchedInfo.getLeaderIp();
                        port = matchedInfo.getLeaderPort();
                    }
                }
            }
            List<String> tp = Arrays.asList(host, String.valueOf(port), tableName, actionName);
            List usr = (List)this.users.get(tp);
            String user = (String)usr.get(0);
            String pwd = (String)usr.get(1);
            log.debug("Connecting to server " + host + ":" + port + " to send unsubscribe signal (backupSite mode) for " + originalFullTableName);
            if (!user.equals("")) {
                dbConn.connect(host, port, user, pwd);
            } else {
                dbConn.connect(host, port);
            }
            log.debug("Connected to server " + host + ":" + port + " successfully (backupSite mode)");
            try {
                String fullTableName = host + ":" + port + "/" + tableName + "/" + actionName;
                String topic2 = (String)this.tableNameToTrueTopic.get(fullTableName);
                log.debug("Retrieved topic from tableNameToTrueTopic: " + topic2 + " for " + fullTableName);
                Site[] sites = (Site[])this.trueTopicToSites.get(topic2);
                if (sites == null || sites.length == 0) {
                    log.warn("No sites found for topic: " + topic2);
                } else {
                    log.debug("Marking " + sites.length + " site(s) as closed for topic: " + topic2 + " BEFORE sending stopPublishTable (backupSite mode)");
                    for (int i = 0; i < sites.length; ++i) {
                        sites[i].closed = true;
                        log.debug("Site " + i + " marked as closed: " + sites[i].host + ":" + sites[i].port);
                    }
                }
                String localIP = this.listeningHost;
                if (localIP.equals("")) {
                    localIP = dbConn.getLocalAddress().getHostAddress();
                }
                ArrayList<Entity> params = new ArrayList<Entity>();
                params.add(new BasicString(localIP));
                params.add(new BasicInt(this.listeningPort));
                params.add(new BasicString(tableName));
                params.add(new BasicString(actionName));
                log.debug("Sending stopPublishTable command (backupSite mode) with params: localIP=" + localIP + ", listeningPort=" + this.listeningPort + ", tableName=" + tableName + ", actionName=" + actionName);
                dbConn.run("stopPublishTable", params);
                log.debug("stopPublishTable command executed successfully (backupSite mode) for " + originalFullTableName);
                this.queueManager.removeQueue(topic2);
                log.debug("Queue removed from queueManager for topic: " + topic2);
                if (AbstractClient.ifUseBackupSite) {
                    log.debug("Resetting backupSite related parameters");
                    AbstractClient.ifUseBackupSite = false;
                    AbstractClient.subOnce = false;
                    AbstractClient.resubscribeInterval = 100;
                }
                log.debug("Successfully unsubscribed table " + fullTableName);
            }
            catch (Exception ex) {
                log.error("Error occurred during unsubscribe (backupSite mode) for " + originalFullTableName, (Throwable)ex);
                throw ex;
            }
            finally {
                dbConn.close();
                log.debug("DBConnection closed (backupSite mode) for " + originalFullTableName);
                String topicStr = originHost + ":" + originPort + "/" + tableName + "/" + actionName;
                HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
                synchronized (hashMap) {
                    this.queueHandlers.remove(topicStr);
                }
                log.debug("Unsubscribe process completed (backupSite mode) for " + originalFullTableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers = null;
        }
        this.threadPool.shutdownNow();
        if (this.pThread != null) {
            this.pThread.interrupt();
        }
        this.isClose_ = true;
    }

    class HandlerRunner
    implements Runnable {
        MessageHandler handler;
        IMessage message;

        HandlerRunner(MessageHandler handler, IMessage message) {
            this.handler = handler;
            this.message = message;
        }

        @Override
        public void run() {
            this.handler.doEvent(this.message);
        }
    }

    private class QueueHandlerBinder {
        private BlockingQueue<List<IMessage>> queue;
        private MessageHandler handler;

        public QueueHandlerBinder(BlockingQueue<List<IMessage>> queue, MessageHandler handler) {
            this.queue = queue;
            this.handler = handler;
        }
    }
}

