/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.objectPool;

import dorkbox.util.objectPool.PoolableObject;
import java.util.concurrent.ArrayBlockingQueue;

public class ObjectPool<T> {
    private final ArrayBlockingQueue<T> queue;
    private final PoolableObject<T> poolableObject;

    ObjectPool(PoolableObject<T> poolableObject, int size) {
        this.poolableObject = poolableObject;
        this.queue = new ArrayBlockingQueue(size);
        for (int x = 0; x < size; ++x) {
            T e = poolableObject.create();
            poolableObject.onReturn(e);
            this.queue.add(e);
        }
    }

    public T take() throws InterruptedException {
        T take = this.queue.take();
        this.poolableObject.onTake(take);
        return take;
    }

    public T takeUninterruptibly() {
        try {
            T take = this.take();
            return take;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void release(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(object);
    }

    public T newInstance() {
        return this.poolableObject.create();
    }

    public int size() {
        return this.queue.size();
    }
}

