/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectpool;

import dorkbox.objectpool.BlockingPool;
import dorkbox.objectpool.NonBlockingPool;
import dorkbox.objectpool.NonBlockingSoftPool;
import dorkbox.objectpool.Pool;
import dorkbox.objectpool.PoolableObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;

public abstract class ObjectPool<T>
implements Pool<T> {
    public static String getVersion() {
        return "2.9";
    }

    public static <T> ObjectPool<T> Blocking(PoolableObject<T> poolableObject, int size) {
        return new BlockingPool<T>(poolableObject, size);
    }

    public static <T> ObjectPool<T> Blocking(PoolableObject<T> poolableObject, BlockingQueue<T> queue, int size) {
        return new BlockingPool<T>(poolableObject, queue, size);
    }

    public static <T> ObjectPool<T> NonBlocking(PoolableObject<T> poolableObject) {
        return new NonBlockingPool<T>(poolableObject);
    }

    public static <T> ObjectPool<T> NonBlocking(PoolableObject<T> poolableObject, Queue<T> queue) {
        return new NonBlockingPool<T>(poolableObject, queue);
    }

    public static <T> ObjectPool<T> NonBlockingSoftReference(PoolableObject<T> poolableObject) {
        return new NonBlockingSoftPool<T>(poolableObject);
    }

    public static <T> ObjectPool<T> NonBlockingSoftReference(PoolableObject<T> poolableObject, Queue<SoftReference<T>> queue) {
        return new NonBlockingSoftPool<T>(poolableObject, queue);
    }
}

