/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class NonBlockingSoftPool<T>
extends ObjectPool<T> {
    private final Queue<SoftReference<T>> queue;
    private final PoolableObject<T> poolableObject;

    NonBlockingSoftPool(PoolableObject<T> poolableObject) {
        this(poolableObject, new ConcurrentLinkedQueue<SoftReference<T>>());
    }

    NonBlockingSoftPool(PoolableObject<T> poolableObject, Queue<SoftReference<T>> queue) {
        this.poolableObject = poolableObject;
        this.queue = queue;
    }

    @Override
    public T take() {
        SoftReference<T> ref;
        while ((ref = this.queue.poll()) != null) {
            T obj = ref.get();
            if (obj == null) continue;
            this.poolableObject.onTake(obj);
            return obj;
        }
        T take = this.poolableObject.create();
        this.poolableObject.onTake(take);
        return take;
    }

    @Override
    public T takeInterruptibly() throws InterruptedException {
        return this.take();
    }

    @Override
    public void put(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(new SoftReference<T>(object));
    }

    @Override
    public T newInstance() {
        return this.poolableObject.create();
    }
}

