/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import dorkbox.objectPool.SuspendingPool;
import dorkbox.objectPool.SuspendingPoolObject;
import dorkbox.objectPool.blocking.BlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingSoftPool;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bJ.\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0011J \u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bJ4\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00130\u0011J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u0015\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ6\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u0015\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\t0\u00182\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Ldorkbox/objectPool/ObjectPool;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "blocking", "Ldorkbox/objectPool/Pool;", "T", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/concurrent/BlockingQueue;", "size", "", "nonBlocking", "Ljava/util/Queue;", "nonBlockingSoftReference", "Ljava/lang/ref/SoftReference;", "suspending", "Ldorkbox/objectPool/SuspendingPool;", "Ldorkbox/objectPool/SuspendingPoolObject;", "channel", "Lkotlinx/coroutines/channels/Channel;", "ObjectPool"})
public final class ObjectPool {
    public static final ObjectPool INSTANCE;

    @NotNull
    public final String getVersion() {
        return "3.0";
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.suspending(poolObject, ChannelKt.Channel((int)size), size);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, @NotNull Channel<T> channel, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        return new dorkbox.objectPool.suspending.SuspendingPool<T>(poolObject, channel, size);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new BlockingPool<T>(poolObject, (BlockingQueue)new DisruptorBlockingQueue(size), size);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, @NotNull BlockingQueue<T> queue, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BlockingPool<T>(poolObject, queue, size);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new NonBlockingPool(poolObject, null, 2, null);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new NonBlockingSoftPool(poolObject, null, 2, null);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingSoftPool<T>(poolObject, queue);
    }

    private ObjectPool() {
    }

    static {
        ObjectPool objectPool;
        INSTANCE = objectPool = new ObjectPool();
    }
}

