/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.BoundedPoolObject;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldorkbox/objectPool/nonBlocking/BoundedNonBlockingPool;", "T", "Ldorkbox/objectPool/nonBlocking/NonBlockingPool;", "poolObject", "Ldorkbox/objectPool/BoundedPoolObject;", "maxSize", "", "queue", "Ljava/util/Queue;", "(Ldorkbox/objectPool/BoundedPoolObject;JLjava/util/Queue;)V", "currentSize", "Ljava/util/concurrent/atomic/AtomicLong;", "newInstance", "()Ljava/lang/Object;", "put", "", "object", "(Ljava/lang/Object;)V", "ObjectPool"})
public final class BoundedNonBlockingPool<T>
extends NonBlockingPool<T> {
    private final AtomicLong currentSize;
    private final BoundedPoolObject<T> poolObject;
    private final long maxSize;
    private final Queue<T> queue;

    @Override
    public void put(T object) {
        if (this.currentSize.get() <= this.maxSize) {
            this.poolObject.onReturn(object);
            this.queue.offer(object);
        } else {
            this.currentSize.decrementAndGet();
            this.poolObject.onRemoval(object);
        }
    }

    @Override
    public T newInstance() {
        this.currentSize.incrementAndGet();
        return this.poolObject.newInstance();
    }

    public BoundedNonBlockingPool(@NotNull BoundedPoolObject<T> poolObject, long maxSize, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        super(poolObject, queue);
        this.poolObject = poolObject;
        this.maxSize = maxSize;
        this.queue = queue;
        this.currentSize = new AtomicLong(0L);
    }

    public /* synthetic */ BoundedNonBlockingPool(BoundedPoolObject boundedPoolObject, long l, Queue queue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        this(boundedPoolObject, l, queue);
    }
}

