/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\r\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldorkbox/objectPool/nonBlocking/NonBlockingSoftPool;", "T", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/Queue;", "Ljava/lang/ref/SoftReference;", "(Ldorkbox/objectPool/PoolObject;Ljava/util/Queue;)V", "newInstance", "()Ljava/lang/Object;", "put", "", "object", "(Ljava/lang/Object;)V", "take", "takeInterruptibly", "ObjectPool"})
public final class NonBlockingSoftPool<T>
implements Pool<T> {
    private final PoolObject<T> poolObject;
    private final Queue<SoftReference<T>> queue;

    @Override
    public T take() {
        return this.takeInterruptibly();
    }

    @Override
    public T takeInterruptibly() {
        T obj = null;
        SoftReference<T> ref = this.queue.poll();
        if (ref != null && (obj = (T)ref.get()) != null) {
            this.poolObject.onTake(obj);
            return obj;
        }
        T take2 = this.poolObject.newInstance();
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(T object) {
        this.poolObject.onReturn(object);
        this.queue.offer(new SoftReference<T>(object));
    }

    @Override
    public T newInstance() {
        return this.poolObject.newInstance();
    }

    public NonBlockingSoftPool(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
    }

    public /* synthetic */ NonBlockingSoftPool(PoolObject poolObject, Queue queue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        this(poolObject, queue);
    }
}

