/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import dorkbox.objectPool.BoundedPoolObject;
import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import dorkbox.objectPool.SuspendingPool;
import dorkbox.objectPool.SuspendingPoolObject;
import dorkbox.objectPool.blocking.BlockingPool;
import dorkbox.objectPool.nonBlocking.BoundedNonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingSoftPool;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ.\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000fJ(\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000fJ \u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ4\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00150\u000fJ(\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0017\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00182\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldorkbox/objectPool/ObjectPool;", "", "()V", "version", "", "blocking", "Ldorkbox/objectPool/Pool;", "T", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/concurrent/BlockingQueue;", "size", "", "nonBlocking", "Ljava/util/Queue;", "nonBlockingBounded", "Ldorkbox/objectPool/BoundedPoolObject;", "maxSize", "", "nonBlockingSoftReference", "Ljava/lang/ref/SoftReference;", "suspending", "Ldorkbox/objectPool/SuspendingPool;", "Ldorkbox/objectPool/SuspendingPoolObject;", "ObjectPool"})
public final class ObjectPool {
    @NotNull
    public static final String version = "3.2";
    @NotNull
    public static final ObjectPool INSTANCE;

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new dorkbox.objectPool.suspending.SuspendingPool<T>(poolObject, size);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.blocking(poolObject, (BlockingQueue)new DisruptorBlockingQueue(size), size);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, @NotNull BlockingQueue<T> queue, int size) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BlockingPool<T>(poolObject, queue, size);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new NonBlockingPool(poolObject, null, 2, null);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new NonBlockingSoftPool(poolObject, null, 2, null);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingSoftPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, long maxSize) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return new BoundedNonBlockingPool(poolObject, maxSize, null, 4, null);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, long maxSize, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BoundedNonBlockingPool<T>(poolObject, maxSize, queue);
    }

    private ObjectPool() {
    }

    static {
        ObjectPool objectPool;
        INSTANCE = objectPool = new ObjectPool();
    }
}

