/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\r\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/objectPool/nonBlocking/NonBlockingPool;", "T", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/Queue;", "(Ldorkbox/objectPool/PoolObject;Ljava/util/Queue;)V", "newInstance", "()Ljava/lang/Object;", "put", "", "object", "(Ljava/lang/Object;)V", "take", "takeInterruptibly", "ObjectPool"})
public class NonBlockingPool<T>
implements Pool<T> {
    @NotNull
    private final PoolObject<T> poolObject;
    @NotNull
    private final Queue<T> queue;

    public NonBlockingPool(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
    }

    public /* synthetic */ NonBlockingPool(PoolObject poolObject, Queue queue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        this(poolObject, queue);
    }

    @Override
    public T take() {
        return this.takeInterruptibly();
    }

    @Override
    public T takeInterruptibly() {
        T take2 = this.queue.poll();
        if (take2 == null) {
            take2 = this.newInstance();
        }
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(T object) {
        this.poolObject.onReturn(object);
        this.queue.offer(object);
    }

    @Override
    public T newInstance() {
        return this.poolObject.newInstance();
    }
}

