/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.blocking;

import dorkbox.objectPool.Pool;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldorkbox/objectPool/blocking/BlockingPoolCollection;", "T", "Ldorkbox/objectPool/Pool;", "queue", "Ljava/util/concurrent/BlockingQueue;", "collection", "", "(Ljava/util/concurrent/BlockingQueue;Ljava/util/Collection;)V", "dummyValue", "Ljava/lang/Object;", "close", "", "newInstance", "()Ljava/lang/Object;", "put", "object", "(Ljava/lang/Object;)V", "take", "takeInterruptibly", "ObjectPool"})
public final class BlockingPoolCollection<T>
implements Pool<T> {
    @NotNull
    private final BlockingQueue<T> queue;
    private final T dummyValue;

    public BlockingPoolCollection(@NotNull BlockingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.queue = queue;
        this.dummyValue = CollectionsKt.elementAt((Iterable)collection, (int)0);
        for (T it : collection) {
            this.queue.offer(it);
        }
    }

    @Override
    public T take() {
        T t;
        try {
            t = this.takeInterruptibly();
        }
        catch (InterruptedException ignored) {
            t = this.dummyValue;
        }
        return t;
    }

    @Override
    public T takeInterruptibly() {
        return this.queue.take();
    }

    @Override
    public void put(T object) {
        this.queue.put(object);
    }

    @Override
    public T newInstance() {
        return this.dummyValue;
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

