/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\r\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldorkbox/objectPool/nonBlocking/NonBlockingSoftPool;", "T", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/Queue;", "Ljava/lang/ref/SoftReference;", "(Ldorkbox/objectPool/PoolObject;Ljava/util/Queue;)V", "close", "", "newInstance", "()Ljava/lang/Object;", "put", "object", "(Ljava/lang/Object;)V", "take", "takeInterruptibly", "ObjectPool"})
public final class NonBlockingSoftPool<T>
implements Pool<T> {
    @NotNull
    private final PoolObject<T> poolObject;
    @NotNull
    private final Queue<SoftReference<T>> queue;

    public NonBlockingSoftPool(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
    }

    @Override
    public T take() {
        return this.takeInterruptibly();
    }

    @Override
    public T takeInterruptibly() {
        T obj = null;
        SoftReference<T> ref = this.queue.poll();
        if (ref != null && (obj = (T)ref.get()) != null) {
            this.poolObject.onTake(obj);
            return obj;
        }
        T take2 = this.poolObject.newInstance();
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(T object) {
        this.poolObject.onReturn(object);
        this.queue.offer(new SoftReference<T>(object));
    }

    @Override
    public T newInstance() {
        return this.poolObject.newInstance();
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

