/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.BoundedPoolObject;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldorkbox/objectPool/nonBlocking/BoundedNonBlockingPool;", "T", "", "Ldorkbox/objectPool/nonBlocking/NonBlockingPool;", "poolObject", "Ldorkbox/objectPool/BoundedPoolObject;", "maxSize", "", "queue", "Ljava/util/Queue;", "(Ldorkbox/objectPool/BoundedPoolObject;ILjava/util/Queue;)V", "currentSize", "Ljava/util/concurrent/atomic/AtomicLong;", "newInstance", "()Ljava/lang/Object;", "put", "", "object", "(Ljava/lang/Object;)V", "ObjectPool"})
public final class BoundedNonBlockingPool<T>
extends NonBlockingPool<T> {
    @NotNull
    private final BoundedPoolObject<T> poolObject;
    private final int maxSize;
    @NotNull
    private final Queue<T> queue;
    @NotNull
    private final AtomicLong currentSize;

    public BoundedNonBlockingPool(@NotNull BoundedPoolObject<T> poolObject, int maxSize, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        super(poolObject, queue);
        this.poolObject = poolObject;
        this.maxSize = maxSize;
        this.queue = queue;
        this.currentSize = new AtomicLong(0L);
    }

    @Override
    public void put(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        if (this.currentSize.get() <= (long)this.maxSize) {
            this.poolObject.onReturn(object);
            this.queue.offer(object);
        } else {
            this.currentSize.decrementAndGet();
            this.poolObject.onRemove(object);
        }
    }

    @Override
    @NotNull
    public T newInstance() {
        this.currentSize.incrementAndGet();
        return this.poolObject.newInstance();
    }
}

