/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import dorkbox.objectPool.BoundedPoolObject;
import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import dorkbox.objectPool.SuspendingPool;
import dorkbox.objectPool.SuspendingPoolObject;
import dorkbox.objectPool.blocking.BlockingPool;
import dorkbox.objectPool.blocking.BlockingPoolCollection;
import dorkbox.objectPool.nonBlocking.BoundedNonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingSoftPool;
import dorkbox.objectPool.suspending.ChannelQueue;
import dorkbox.objectPool.suspending.SuspendingPoolCollection;
import dorkbox.objectPool.suspending.SuspendingQueue;
import dorkbox.updates.Updates;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJD\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00102\b\b\u0002\u0010\r\u001a\u00020\u000eJ6\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJD\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ$\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u0013J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u0013J8\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00180\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u001a2\u0006\u0010\u001b\u001a\u00020\fJ:\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u001a2\u0006\u0010\u001b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0016J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\b0\u001dJ2\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\b0\u001dJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\b0\u001dJ2\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\b0\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldorkbox/objectPool/ObjectPool;", "", "<init>", "()V", "version", "", "suspending", "Ldorkbox/objectPool/SuspendingPool;", "T", "poolObject", "Ldorkbox/objectPool/SuspendingPoolObject;", "size", "", "initiallyFillPool", "", "queue", "Ldorkbox/objectPool/suspending/SuspendingQueue;", "blocking", "Ldorkbox/objectPool/Pool;", "Ldorkbox/objectPool/PoolObject;", "Ljava/util/concurrent/BlockingQueue;", "nonBlocking", "Ljava/util/Queue;", "nonBlockingSoftReference", "Ljava/lang/ref/SoftReference;", "nonBlockingBounded", "Ldorkbox/objectPool/BoundedPoolObject;", "maxSize", "collection", "", "ObjectPool"})
public final class ObjectPool {
    @NotNull
    public static final ObjectPool INSTANCE = new ObjectPool();
    @NotNull
    public static final String version = "5.0";

    private ObjectPool() {
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.suspending(poolObject, size, new ChannelQueue(size), initiallyFillPool);
    }

    public static /* synthetic */ SuspendingPool suspending$default(ObjectPool objectPool, SuspendingPoolObject suspendingPoolObject, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return objectPool.suspending(suspendingPoolObject, n, bl);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size, @NotNull SuspendingQueue<T> queue, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new dorkbox.objectPool.suspending.SuspendingPool<T>(poolObject, size, queue, initiallyFillPool);
    }

    public static /* synthetic */ SuspendingPool suspending$default(ObjectPool objectPool, SuspendingPoolObject suspendingPoolObject, int n, SuspendingQueue suspendingQueue, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return objectPool.suspending(suspendingPoolObject, n, suspendingQueue, bl);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.blocking(poolObject, (BlockingQueue)new DisruptorBlockingQueue(size), size, initiallyFillPool);
    }

    public static /* synthetic */ Pool blocking$default(ObjectPool objectPool, PoolObject poolObject, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return objectPool.blocking(poolObject, n, bl);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, @NotNull BlockingQueue<T> queue, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BlockingPool<T>(poolObject, queue, size, initiallyFillPool);
    }

    public static /* synthetic */ Pool blocking$default(ObjectPool objectPool, PoolObject poolObject, BlockingQueue blockingQueue, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return objectPool.blocking(poolObject, blockingQueue, n, bl);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlocking(poolObject, new ConcurrentLinkedQueue());
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlockingSoftReference(poolObject, new ConcurrentLinkedQueue());
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingSoftPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, int maxSize) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlockingBounded(poolObject, maxSize, (Queue)new DisruptorBlockingQueue(maxSize));
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, int maxSize, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BoundedNonBlockingPool<T>(poolObject, maxSize, queue);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return this.suspending(new ChannelQueue(collection.size()), collection);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new SuspendingPoolCollection<T>(queue, collection);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return this.blocking((BlockingQueue)new DisruptorBlockingQueue(collection.size()), collection);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull BlockingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new BlockingPoolCollection<T>(queue, collection);
    }

    static {
        Updates.INSTANCE.add(ObjectPool.class, "1dc60a2801d941cba9c7964255d8b061", version);
    }
}

