/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.blocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldorkbox/objectPool/blocking/BlockingPool;", "T", "", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/concurrent/BlockingQueue;", "size", "", "fillPool", "", "<init>", "(Ldorkbox/objectPool/PoolObject;Ljava/util/concurrent/BlockingQueue;IZ)V", "take", "()Ljava/lang/Object;", "takeInterruptibly", "put", "", "object", "(Ljava/lang/Object;)V", "newInstance", "close", "ObjectPool"})
public final class BlockingPool<T>
implements Pool<T> {
    @NotNull
    private final PoolObject<T> poolObject;
    @NotNull
    private final BlockingQueue<T> queue;

    public BlockingPool(@NotNull PoolObject<T> poolObject, @NotNull BlockingQueue<T> queue, int size, boolean fillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
        if (fillPool) {
            for (int x = 0; x < size; ++x) {
                T e = this.newInstance();
                this.poolObject.onReturn(e);
                this.queue.offer(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public T take() {
        T t;
        try {
            t = this.takeInterruptibly();
        }
        catch (InterruptedException e) {
            void var3_3;
            T newInstance = this.newInstance();
            this.poolObject.onTake(newInstance);
            t = var3_3;
        }
        return t;
    }

    @Override
    @NotNull
    public T takeInterruptibly() {
        T take2 = this.queue.take();
        Intrinsics.checkNotNull(take2);
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.poolObject.onReturn(object);
        this.queue.put(object);
    }

    @Override
    @NotNull
    public T newInstance() {
        return this.poolObject.newInstance();
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

