/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.blocking;

import dorkbox.objectPool.Pool;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ldorkbox/objectPool/blocking/BlockingPoolCollection;", "T", "", "Ldorkbox/objectPool/Pool;", "queue", "Ljava/util/concurrent/BlockingQueue;", "collection", "", "<init>", "(Ljava/util/concurrent/BlockingQueue;Ljava/util/Collection;)V", "dummyValue", "Ljava/lang/Object;", "take", "()Ljava/lang/Object;", "takeInterruptibly", "put", "", "object", "(Ljava/lang/Object;)V", "newInstance", "close", "ObjectPool"})
public final class BlockingPoolCollection<T>
implements Pool<T> {
    @NotNull
    private final BlockingQueue<T> queue;
    @NotNull
    private final T dummyValue;

    public BlockingPoolCollection(@NotNull BlockingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.queue = queue;
        this.dummyValue = CollectionsKt.elementAt((Iterable)collection, (int)0);
        for (T it : collection) {
            this.queue.offer(it);
        }
    }

    @Override
    @NotNull
    public T take() {
        T t;
        try {
            t = this.takeInterruptibly();
        }
        catch (InterruptedException ignored) {
            t = this.dummyValue;
        }
        return t;
    }

    @Override
    @NotNull
    public T takeInterruptibly() {
        T t = this.queue.take();
        Intrinsics.checkNotNullExpressionValue(t, (String)"take(...)");
        return t;
    }

    @Override
    public void put(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.queue.put(object);
    }

    @Override
    @NotNull
    public T newInstance() {
        return this.dummyValue;
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

