/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldorkbox/objectPool/nonBlocking/NonBlockingPool;", "T", "", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/Queue;", "<init>", "(Ldorkbox/objectPool/PoolObject;Ljava/util/Queue;)V", "take", "()Ljava/lang/Object;", "takeInterruptibly", "put", "", "object", "(Ljava/lang/Object;)V", "newInstance", "close", "ObjectPool"})
public class NonBlockingPool<T>
implements Pool<T> {
    @NotNull
    private final PoolObject<T> poolObject;
    @NotNull
    private final Queue<T> queue;

    public NonBlockingPool(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
    }

    @Override
    @NotNull
    public T take() {
        return this.takeInterruptibly();
    }

    @Override
    @NotNull
    public T takeInterruptibly() {
        T take2 = this.queue.poll();
        if (take2 == null) {
            take2 = this.newInstance();
        }
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.poolObject.onReturn(object);
        this.queue.offer(object);
    }

    @Override
    @NotNull
    public T newInstance() {
        return this.poolObject.newInstance();
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

