/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool.nonBlocking;

import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import java.lang.ref.SoftReference;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldorkbox/objectPool/nonBlocking/NonBlockingSoftPool;", "T", "", "Ldorkbox/objectPool/Pool;", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/Queue;", "Ljava/lang/ref/SoftReference;", "<init>", "(Ldorkbox/objectPool/PoolObject;Ljava/util/Queue;)V", "take", "()Ljava/lang/Object;", "takeInterruptibly", "put", "", "object", "(Ljava/lang/Object;)V", "newInstance", "close", "ObjectPool"})
public final class NonBlockingSoftPool<T>
implements Pool<T> {
    @NotNull
    private final PoolObject<T> poolObject;
    @NotNull
    private final Queue<SoftReference<T>> queue;

    public NonBlockingSoftPool(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        this.poolObject = poolObject;
        this.queue = queue;
    }

    @Override
    @NotNull
    public T take() {
        return this.takeInterruptibly();
    }

    @Override
    @NotNull
    public T takeInterruptibly() {
        T obj = null;
        SoftReference<T> ref = this.queue.poll();
        if (ref != null && (obj = (T)ref.get()) != null) {
            this.poolObject.onTake(obj);
            return obj;
        }
        T take2 = this.poolObject.newInstance();
        this.poolObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        this.poolObject.onReturn(object);
        this.queue.offer(new SoftReference<T>(object));
    }

    @Override
    @NotNull
    public T newInstance() {
        return this.poolObject.newInstance();
    }

    @Override
    public void close() {
        this.queue.clear();
    }
}

