/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.swt;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SwtAccess {
    private static Display currentDisplay = null;
    private static Thread currentDisplayThread = null;

    public static void init() {
        currentDisplay = Display.getCurrent();
        currentDisplayThread = currentDisplay.getThread();
    }

    static boolean isLoadable() {
        return SWT.isLoadable();
    }

    static void onShutdown(Display currentDisplay, final Runnable runnable) {
        Shell shell = currentDisplay.getShells()[0];
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                runnable.run();
            }
        });
    }

    static int getVersion() {
        return SWT.getVersion();
    }

    static boolean isGtk3() {
        boolean isLinux = System.getProperty("os.name", "").toLowerCase(Locale.US).startsWith("linux");
        if (!isLinux) {
            return false;
        }
        String SWT_INTERNAL_CLASS = "org.eclipse.swt.internal.gtk.OS";
        Class osClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName("org.eclipse.swt.internal.gtk.OS", true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception exception) {
                    try {
                        return Class.forName("org.eclipse.swt.internal.gtk.OS", true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                }
            }
        });
        if (osClass == null) {
            return false;
        }
        final Class clazz = osClass;
        Method method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (method == null) {
            return false;
        }
        int version = 0;
        try {
            version = ((Number)method.invoke((Object)osClass, new Object[0])).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version == 3;
    }

    static void dispatch(Runnable runnable) {
        currentDisplay.syncExec(runnable);
    }

    static boolean isEventThread() {
        return Thread.currentThread() == currentDisplayThread;
    }

    static void onShutdown(final Runnable runnable) {
        if (SwtAccess.isEventThread()) {
            SwtAccess.onShutdown(currentDisplay, runnable);
        } else {
            SwtAccess.dispatch(new Runnable(){

                @Override
                public void run() {
                    SwtAccess.onShutdown(currentDisplay, runnable);
                }
            });
        }
    }
}

