/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.javaFx;

import dorkbox.javaFx.JavaFxAccess;
import dorkbox.swt.Swt;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.LoggerFactory;

public class JavaFx {
    public static final boolean isLoaded;
    public static final boolean isGtk3;

    public static void dispatch(Runnable runnable) {
        JavaFxAccess.dispatch(runnable);
    }

    public static boolean isEventThread() {
        return JavaFxAccess.isEventThread();
    }

    public static void onShutdown(Runnable runnable) {
        JavaFxAccess.onShutdown(runnable);
    }

    static {
        String fullJavaVersion = System.getProperty("java.version", "");
        boolean isJava8 = fullJavaVersion.startsWith("1.") && fullJavaVersion.charAt(2) == '8';
        Class javaFxLoggerClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName("com.sun.javafx.logging.PlatformLogger", true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception exception) {
                    try {
                        return Class.forName("com.sun.javafx.logging.PlatformLogger", true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                }
            }
        });
        boolean isJavaFxLoaded_ = false;
        try {
            if (javaFxLoggerClass != null) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    if (!stackTrace[i].getClassName().contains("javafx")) continue;
                    isJavaFxLoaded_ = true;
                    break;
                }
                if (!isJavaFxLoaded_) {
                    String usingJavFx = System.getProperty("usingJavaFx", "false");
                    if (!usingJavFx.equals("false")) {
                        isJavaFxLoaded_ = true;
                    } else {
                        LoggerFactory.getLogger(JavaFx.class).debug("Using reflection to detect if JavaFX is loaded.\nTo avoid using reflection, set the system property \"usingJavaFx\" to \"true\" before your application starts.  For example: System.setProperty(\"usingJavaFx\", \"true\");");
                        Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                        m.setAccessible(true);
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        isJavaFxLoaded_ = null != m.invoke((Object)cl, "com.sun.javafx.tk.Toolkit") || null != m.invoke((Object)cl, "javafx.application.Application");
                    }
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(JavaFx.class).debug("Error detecting if JavaFX is loaded", e);
        }
        boolean isJavaFxGtk3_ = false;
        if (isJavaFxLoaded_) {
            if (isJava8) {
                isJavaFxGtk3_ = false;
            } else if (Swt.isLoaded && !Swt.isGtk3) {
                isJavaFxGtk3_ = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        String version = System.getProperty("jdk.gtk.version", "2");
                        return "3".equals(version) || version.startsWith("3.");
                    }
                });
            }
        }
        isLoaded = isJavaFxLoaded_;
        isGtk3 = isJavaFxGtk3_;
    }
}

