/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SwtAccess {
    private static Display currentDisplay = null;
    private static Thread currentDisplayThread = null;

    public static void init() {
        currentDisplay = Display.getCurrent();
        currentDisplayThread = currentDisplay.getThread();
    }

    static boolean isLoadable() {
        return SWT.isLoadable();
    }

    static void onShutdown(Display currentDisplay, final Runnable runnable) {
        Shell shell = currentDisplay.getShells()[0];
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                runnable.run();
            }
        });
    }

    static int getVersion() {
        return SWT.getVersion();
    }

    private static int getViaReflection(final String clazz) throws InvocationTargetException, IllegalAccessException {
        final Class osClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(clazz, true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception exception) {
                    try {
                        return Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                }
            }
        });
        Method method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return osClass.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        return ((Number)method.invoke((Object)osClass, new Object[0])).intValue();
    }

    static boolean isGtk3() {
        boolean isLinux = System.getProperty("os.name", "").toLowerCase(Locale.US).startsWith("linux");
        if (!isLinux) {
            return false;
        }
        try {
            return GTK.gtk_get_major_version() == 3;
        }
        catch (Exception e) {
            try {
                return SwtAccess.getViaReflection("org.eclipse.swt.internal.gtk.GTK") == 3;
            }
            catch (Exception e1) {
                try {
                    return SwtAccess.getViaReflection("org.eclipse.swt.internal.gtk.OS") == 3;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    static void dispatch(Runnable runnable) {
        currentDisplay.syncExec(runnable);
    }

    static boolean isEventThread() {
        return Thread.currentThread() == currentDisplayThread;
    }
}

