/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.javaFx;

import dorkbox.jna.rendering.ProviderType;
import dorkbox.jna.rendering.Renderer;
import dorkbox.os.OS;
import javafx.application.Platform;

public class JavaFxProvider
implements Renderer {
    public boolean isSupported() {
        return true;
    }

    public ProviderType getType() {
        return ProviderType.JAVAFX;
    }

    public boolean alreadyRunning() {
        return false;
    }

    public boolean isEventThread() {
        return Platform.isFxApplicationThread();
    }

    public int getGtkVersion() {
        if (!OS.isLinux()) {
            return 0;
        }
        if (OS.javaVersion < 9) {
            return 2;
        }
        String version = OS.getProperty((String)"jdk.gtk.version", (String)"2");
        if ("3".equals(version) || version.startsWith("3.")) {
            return 3;
        }
        return 2;
    }

    public boolean dispatch(Runnable runnable) {
        if (this.isEventThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
        return true;
    }
}

