/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    protected static final AtomicInteger POOL_SEQ = new AtomicInteger(1);
    protected final AtomicInteger mThreadNum = new AtomicInteger(1);
    protected final String mPrefix;
    protected final boolean mDaemon;
    protected final ThreadGroup mGroup;
    protected final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public NamedThreadFactory() {
        this("pool-" + POOL_SEQ.getAndIncrement(), false, null);
    }

    public NamedThreadFactory(String prefix) {
        this(prefix, false, null);
    }

    public NamedThreadFactory(String prefix, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(prefix, false, uncaughtExceptionHandler);
    }

    public NamedThreadFactory(String prefix, boolean daemon, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.mPrefix = prefix + "-t-";
        this.mDaemon = daemon;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        SecurityManager s = System.getSecurityManager();
        this.mGroup = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.mPrefix + this.mThreadNum.getAndIncrement();
        Thread ret = new Thread(this.mGroup, runnable, name, 0L);
        ret.setDaemon(this.mDaemon);
        return ret;
    }

    public ThreadGroup getThreadGroup() {
        return this.mGroup;
    }
}

