/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.concurrent;

import com.echoclsaa.fastool.basic.concurrent.BlockPolicyExecutionHandler;
import com.echoclsaa.fastool.basic.concurrent.ListeningDecorator;
import com.echoclsaa.fastool.basic.concurrent.ListeningExecutorService;
import com.echoclsaa.fastool.basic.concurrent.NamedThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtil {
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, ThreadPoolUtil.createThreadFactory("ScheduledExecutor pool"), new BlockPolicyExecutionHandler("Fastool-ScheduledExecutor pool"));

    private ThreadPoolUtil() {
    }

    public static ListeningExecutorService createListeningExecutor(String name, int corePoolSize, int maxPoolSize, BlockingQueue<Runnable> workQueue) {
        ExecutorService executorService = ThreadPoolUtil.createExecutor(name, corePoolSize, maxPoolSize, workQueue);
        ListeningDecorator listeningExecutorService = new ListeningDecorator(executorService);
        return listeningExecutorService;
    }

    public static ExecutorService createExecutor(String name, int corePoolSize, int maxPoolSize, BlockingQueue<Runnable> workQueue) {
        ThreadFactory threadFactory = ThreadPoolUtil.createThreadFactory(name);
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, workQueue, threadFactory, new BlockPolicyExecutionHandler(name));
    }

    public static ScheduledExecutorService scheduledExecutorService() {
        return executor;
    }

    private static ThreadFactory createThreadFactory(String name) {
        return new NamedThreadFactory("Fastool-" + name, false, (t, e) -> {
            throw new RuntimeException(t.getName() + " e", e);
        });
    }
}

