/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SubTaskStatus {
    NEW("NEW", "\u65b0\u5efa"),
    EXECUTING("EXECUTING", "\u6267\u884c\u4e2d"),
    FINISHED("FINISHED", "\u5df2\u5b8c\u6210"),
    ERROR("ERROR", "\u6267\u884c\u9519\u8bef");

    private static final Map<String, SubTaskStatus> ENUM_MAP;
    private String code;
    private String desc;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private SubTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SubTaskStatus of(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static Boolean isFinished(String code) {
        return SubTaskStatus.FINISHED.code.equals(code);
    }

    public static Boolean isError(String code) {
        return SubTaskStatus.ERROR.code.equals(code);
    }

    public static Boolean isFinalStatus(String code) {
        return SubTaskStatus.isFinished(code) != false || SubTaskStatus.isError(code) != false;
    }

    public static Boolean isNew(String code) {
        return SubTaskStatus.NEW.code.equals(code);
    }

    static {
        ENUM_MAP = Arrays.stream(SubTaskStatus.values()).collect(Collectors.toMap(s -> s.code, s -> s));
    }
}

