/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.convert;

import com.echoclsaa.fastool.basic.convert.Converter;
import com.echoclsaa.fastool.basic.utils.ArrayUtils;
import com.echoclsaa.fastool.basic.utils.CharUtils;
import com.echoclsaa.fastool.basic.utils.ClassUtils;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractConverter<T>
implements Converter<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, defaultValue);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    @Override
    public T convert(Object value, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StringUtils.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue) || ClassUtils.isBasicType(targetType)) {
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            T result = this.convertInternal(value);
            return null == result ? defaultValue : result;
        }
        throw new IllegalArgumentException(StringUtils.format("Default value [{}] is not the instance of [{}]", defaultValue, targetType));
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtils.isArray(value)) {
            return ArrayUtils.toString(value);
        }
        if (CharUtils.isChar(value)) {
            return CharUtils.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtils.getTypeArgument(this.getClass());
    }
}

