/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.convert;

import com.echoclsaa.fastool.basic.convert.ConvertException;
import com.echoclsaa.fastool.basic.convert.Converter;
import com.echoclsaa.fastool.basic.convert.impl.BooleanConverter;
import com.echoclsaa.fastool.basic.convert.impl.CharacterConverter;
import com.echoclsaa.fastool.basic.convert.impl.DateConverter;
import com.echoclsaa.fastool.basic.convert.impl.NumberConverter;
import com.echoclsaa.fastool.basic.convert.impl.PrimitiveConverter;
import com.echoclsaa.fastool.basic.convert.impl.StringConverter;
import com.echoclsaa.fastool.basic.convert.impl.TemporalAccessorConverter;
import com.echoclsaa.fastool.basic.lang.TypeReference;
import com.echoclsaa.fastool.basic.utils.ReflectUtils;
import com.echoclsaa.fastool.basic.utils.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConverterRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Type, Converter<?>> defaultConverterMap;
    private volatile Map<Type, Converter<?>> customConverterMap;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ReflectUtils.newInstance(converterClass, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Converter<T> converter;
        if (TypeUtils.isUnknow(type) && null == defaultValue) {
            return (T)value;
        }
        if (Objects.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtils.isUnknow(type)) {
            type = defaultValue.getClass();
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        Class<?> rowType = TypeUtils.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                return (T)value;
            }
        }
        throw new ConvertException("No Converter for type [{}]", rowType.getName());
    }

    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultConverterMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)AtomicInteger.class), new NumberConverter(AtomicInteger.class));
        this.defaultConverterMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)AtomicLong.class), new NumberConverter(AtomicLong.class));
        this.defaultConverterMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)BigDecimal.class), new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put((Type)((Object)BigInteger.class), new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)java.util.Date.class), new DateConverter(java.util.Date.class));
        this.defaultConverterMap.put((Type)((Object)Date.class), new DateConverter(Date.class));
        this.defaultConverterMap.put((Type)((Object)Time.class), new DateConverter(Time.class));
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), new DateConverter(Timestamp.class));
        this.defaultConverterMap.put((Type)((Object)TemporalAccessor.class), new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)Instant.class), new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)LocalDateTime.class), new TemporalAccessorConverter(LocalDateTime.class));
        this.defaultConverterMap.put((Type)((Object)LocalDate.class), new TemporalAccessorConverter(LocalDate.class));
        this.defaultConverterMap.put((Type)((Object)LocalTime.class), new TemporalAccessorConverter(LocalTime.class));
        this.defaultConverterMap.put((Type)((Object)ZonedDateTime.class), new TemporalAccessorConverter(ZonedDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetDateTime.class), new TemporalAccessorConverter(OffsetDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetTime.class), new TemporalAccessorConverter(OffsetTime.class));
        return this;
    }

    private static class SingletonHolder {
        private static ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

