/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.convert.impl;

import com.echoclsaa.fastool.basic.convert.AbstractConverter;
import com.echoclsaa.fastool.basic.utils.DateUtils;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;
    private Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        Long mills = null;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Number) {
            mills = ((Number)value).longValue();
        } else {
            if (value instanceof TemporalAccessor) {
                return DateUtils.date((TemporalAccessor)value);
            }
            String valueStr = this.convertToStr(value);
            Date date = null;
            try {
                date = StringUtils.isBlank(this.format) ? DateUtils.parse(valueStr) : DateUtils.parse((CharSequence)valueStr, this.format);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (null != date) {
                mills = date.getTime();
            }
        }
        if (null == mills) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringUtils.format("Unsupport Date type: {}", this.targetType.getName()));
    }
}

