/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.exception;

import com.echoclsaa.fastool.basic.constants.HttpStatus;
import com.echoclsaa.fastool.basic.lang.BizCode;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import lombok.Generated;

public abstract class AbstractStandardException
extends RuntimeException {
    private String code = "unknown";
    private int httpStatus;

    public AbstractStandardException(HttpStatus httpStatus) {
        super(null, null, false, true);
        this.httpStatus = httpStatus.value();
    }

    public AbstractStandardException(String message, HttpStatus httpStatus) {
        super(message, null, false, true);
        this.httpStatus = httpStatus.value();
    }

    public AbstractStandardException(Throwable e, HttpStatus httpStatus) {
        super(AbstractStandardException.getMessage(null, e, null, new Object[0]), e, false, true);
        this.httpStatus = httpStatus.value();
        this.resolveException(e);
    }

    public AbstractStandardException(String message, Throwable e, HttpStatus httpStatus) {
        super(AbstractStandardException.getMessage(message, e, null, new Object[0]), e, false, true);
        this.httpStatus = httpStatus.value();
        this.resolveException(e);
    }

    public AbstractStandardException(String message, BizCode bizCode, Throwable e, HttpStatus httpStatus) {
        super(AbstractStandardException.getMessage(message, e, bizCode, new Object[0]), e, false, true);
        this.code = bizCode.getCode();
        this.httpStatus = httpStatus.value();
        this.resolveException(e);
    }

    public AbstractStandardException(BizCode code, Throwable e, HttpStatus httpStatus) {
        super(AbstractStandardException.getMessage(null, e, code, new Object[0]), e, false, true);
        this.code = code.getCode();
        this.httpStatus = httpStatus.value();
        this.resolveException(e);
    }

    public AbstractStandardException(BizCode bizCode, Throwable e, HttpStatus httpStatus, Object ... userMessageParams) {
        super(AbstractStandardException.getMessage(null, e, bizCode, userMessageParams), e, false, e == null);
        this.code = bizCode.getCode();
        this.httpStatus = httpStatus.value();
        this.resolveException(e);
    }

    public static Throwable causeOf(Throwable e) {
        int count = 0;
        Throwable exception = e;
        while (exception != null && count++ < 50) {
            if (exception instanceof AbstractStandardException) {
                return exception;
            }
            Throwable cause = e.getCause();
            if (cause == exception) break;
            exception = cause;
        }
        return e;
    }

    private static String getMessage(String existMessage, Throwable e, BizCode bizCode, Object ... params) {
        String messagePrefix;
        Throwable throwable = AbstractStandardException.causeOf(e);
        String string = messagePrefix = StringUtils.isBlank(existMessage) ? "" : existMessage + "; ";
        if (throwable instanceof AbstractStandardException) {
            if (StringUtils.isBlank(throwable.getMessage())) {
                if (StringUtils.isBlank(existMessage)) {
                    return "no message";
                }
                return existMessage;
            }
            return messagePrefix + throwable.getMessage();
        }
        if (bizCode != null) {
            return messagePrefix + bizCode.parseMessage(params);
        }
        if (StringUtils.isBlank(throwable.getMessage())) {
            if (StringUtils.isBlank(existMessage)) {
                return "no message";
            }
            return existMessage;
        }
        if (StringUtils.isBlank(existMessage)) {
            return throwable.getMessage();
        }
        return messagePrefix + throwable.getMessage();
    }

    private void resolveException(Throwable e) {
        Throwable throwable = AbstractStandardException.causeOf(e);
        if (throwable instanceof AbstractStandardException) {
            this.code = ((AbstractStandardException)e).getCode();
            this.httpStatus = ((AbstractStandardException)e).getHttpStatus();
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractStandardException)) {
            return false;
        }
        AbstractStandardException other = (AbstractStandardException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHttpStatus() != other.getHttpStatus()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractStandardException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHttpStatus();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractStandardException(code=" + this.getCode() + ", httpStatus=" + this.getHttpStatus() + ")";
    }
}

